/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.coverage.KarmaCoverageEngine;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.testFramework.coverage.CoverageSerializationUtils;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(KarmaCoverageRunner.class);
    private KarmaServer myKarmaServer;

    @NotNull
    public static KarmaCoverageRunner getInstance() {
        KarmaCoverageRunner karmaCoverageRunner = (KarmaCoverageRunner)((Object)ObjectUtils.assertNotNull((Object)CoverageRunner.getInstance(KarmaCoverageRunner.class)));
        if (karmaCoverageRunner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageRunner", "getInstance"));
        }
        return karmaCoverageRunner;
    }

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        File basePathDir;
        if (sessionDataFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionDataFile", "com/intellij/javascript/karma/coverage/KarmaCoverageRunner", "loadCoverageData"));
        }
        KarmaConfig karmaConfig = null;
        if (this.myKarmaServer != null) {
            karmaConfig = this.myKarmaServer.getKarmaConfig();
        }
        String basePath = null;
        if (karmaConfig != null) {
            basePath = karmaConfig.getBasePath();
        }
        if (basePath != null && (basePathDir = new File(basePath)).isAbsolute() && basePathDir.isDirectory()) {
            try {
                return KarmaCoverageRunner.readProjectData(sessionDataFile, basePathDir);
            }
            catch (Exception e) {
                LOG.warn("Can't read coverage data", (Throwable)e);
            }
        }
        return null;
    }

    public void setKarmaServer(@NotNull KarmaServer karmaServer) {
        if (karmaServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaServer", "com/intellij/javascript/karma/coverage/KarmaCoverageRunner", "setKarmaServer"));
        }
        this.myKarmaServer = karmaServer;
    }

    @NotNull
    private static ProjectData readProjectData(@NotNull File dataFile, @NotNull File basePath) throws IOException {
        if (dataFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFile", "com/intellij/javascript/karma/coverage/KarmaCoverageRunner", "readProjectData"));
        }
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/javascript/karma/coverage/KarmaCoverageRunner", "readProjectData"));
        }
        ProjectData projectData = new ProjectData();
        LcovCoverageReport report = CoverageSerializationUtils.readLCOV((File)basePath, (File)dataFile);
        for (Map.Entry entry : report.getInfo().entrySet()) {
            String filePath = (String)entry.getKey();
            ClassData classData = projectData.getOrCreateClassData(filePath);
            int max = 0;
            List lineHitsList = (List)entry.getValue();
            if (lineHitsList.size() > 0) {
                LcovCoverageReport.LineHits lastLineHits = (LcovCoverageReport.LineHits)lineHitsList.get(lineHitsList.size() - 1);
                max = lastLineHits.getLineNumber();
            }
            LineData[] lines = new LineData[max + 1];
            for (LcovCoverageReport.LineHits lineHits : lineHitsList) {
                LineData lineData = new LineData(lineHits.getLineNumber(), null);
                lineData.setHits(lineHits.getHits());
                lines[lineHits.getLineNumber()] = lineData;
            }
            classData.setLines(lines);
        }
        ProjectData projectData2 = projectData;
        if (projectData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageRunner", "readProjectData"));
        }
        return projectData2;
    }

    public String getPresentableName() {
        return "KarmaPresentableName";
    }

    public String getId() {
        return "KarmaJavaScriptTestRunnerCoverage";
    }

    public String getDataFileExtension() {
        return "dat";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/javascript/karma/coverage/KarmaCoverageRunner", "acceptsCoverageEngine"));
        }
        return engine instanceof KarmaCoverageEngine;
    }
}

