/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.debug;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggableWebBrowser {
    private final JavaScriptDebugEngine myDebugEngine;
    private final WebBrowser myWebBrowser;

    private DebuggableWebBrowser(@NotNull JavaScriptDebugEngine debugEngine, @NotNull WebBrowser webBrowser) {
        if (debugEngine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugEngine", "com/intellij/javascript/karma/debug/DebuggableWebBrowser", "<init>"));
        }
        if (webBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webBrowser", "com/intellij/javascript/karma/debug/DebuggableWebBrowser", "<init>"));
        }
        this.myDebugEngine = debugEngine;
        this.myWebBrowser = webBrowser;
    }

    @NotNull
    public JavaScriptDebugEngine getDebugEngine() {
        JavaScriptDebugEngine javaScriptDebugEngine = this.myDebugEngine;
        if (javaScriptDebugEngine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/DebuggableWebBrowser", "getDebugEngine"));
        }
        return javaScriptDebugEngine;
    }

    @NotNull
    public WebBrowser getWebBrowser() {
        WebBrowser webBrowser = this.myWebBrowser;
        if (webBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/DebuggableWebBrowser", "getWebBrowser"));
        }
        return webBrowser;
    }

    @Nullable
    public static DebuggableWebBrowser create(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/javascript/karma/debug/DebuggableWebBrowser", "create"));
        }
        JavaScriptDebugEngine debugEngine = JavaScriptDebugEngine.Companion.findByBrowser(browser);
        return debugEngine != null ? new DebuggableWebBrowser(debugEngine, browser) : null;
    }
}

