/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.debug;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.karma.debug.DebuggableWebBrowser;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.server.CapturedBrowser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaDebugBrowserSelector {
    private static final Key<WebBrowser> WEB_BROWSER_KEY = Key.create((String)"KARMA_WEB_BROWSER_ID");
    private final ImmutableList<CapturedBrowser> myCapturedBrowsers;
    private final ExecutionEnvironment myEnvironment;
    private final ConsoleView myConsoleView;

    protected KarmaDebugBrowserSelector(@NotNull Collection<CapturedBrowser> browsers, @NotNull ExecutionEnvironment environment, @NotNull ConsoleView consoleView) {
        if (browsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browsers", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "<init>"));
        }
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "<init>"));
        }
        this.myCapturedBrowsers = ImmutableList.copyOf(browsers);
        this.myEnvironment = environment;
        this.myConsoleView = consoleView;
    }

    @Nullable
    public DebuggableWebBrowser selectDebugEngine() {
        DebuggableWebBrowser debuggableBrowser;
        List<DebuggableWebBrowser> allDebuggableActiveBrowsers = KarmaDebugBrowserSelector.toDebuggableWebBrowsers(WebBrowserManager.getInstance().getActiveBrowsers());
        List<DebuggableWebBrowser> capturedDebuggableActiveBrowsers = this.filterCaptured(allDebuggableActiveBrowsers);
        if (capturedDebuggableActiveBrowsers.size() == 1) {
            DebuggableWebBrowser debuggableWebBrowser = capturedDebuggableActiveBrowsers.get(0);
            this.setWebBrowserToReuse(null);
            return (DebuggableWebBrowser)ObjectUtils.assertNotNull((Object)debuggableWebBrowser);
        }
        WebBrowser browserToReuse = this.getWebBrowserToReuse();
        if (browserToReuse != null && (debuggableBrowser = DebuggableWebBrowser.create(browserToReuse)) != null) {
            return debuggableBrowser;
        }
        if (capturedDebuggableActiveBrowsers.isEmpty() && allDebuggableActiveBrowsers.size() == 1) {
            return (DebuggableWebBrowser)ObjectUtils.assertNotNull((Object)allDebuggableActiveBrowsers.get(0));
        }
        this.printSupportedBrowsers(allDebuggableActiveBrowsers, capturedDebuggableActiveBrowsers);
        return null;
    }

    @NotNull
    private static List<DebuggableWebBrowser> toDebuggableWebBrowsers(@NotNull List<WebBrowser> browsers) {
        if (browsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browsers", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "toDebuggableWebBrowsers"));
        }
        SmartList debuggableWebBrowsers = new SmartList();
        for (WebBrowser browser : browsers) {
            DebuggableWebBrowser debuggableBrowser = DebuggableWebBrowser.create(browser);
            if (debuggableBrowser == null) continue;
            debuggableWebBrowsers.add(debuggableBrowser);
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)debuggableWebBrowsers);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "toDebuggableWebBrowsers"));
        }
        return immutableList;
    }

    @NotNull
    private List<DebuggableWebBrowser> filterCaptured(@NotNull List<DebuggableWebBrowser> debuggableBrowsers) {
        if (debuggableBrowsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggableBrowsers", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "filterCaptured"));
        }
        List captured = ContainerUtil.filter(debuggableBrowsers, debuggableBrowser -> {
            String browserName = debuggableBrowser.getWebBrowser().getName();
            for (CapturedBrowser capturedBrowser : this.myCapturedBrowsers) {
                if (!StringUtil.containsIgnoreCase((String)capturedBrowser.getName(), (String)browserName)) continue;
                return true;
            }
            return false;
        });
        ImmutableList immutableList = ImmutableList.copyOf((Collection)captured);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "filterCaptured"));
        }
        return immutableList;
    }

    @Nullable
    private WebBrowser getWebBrowserToReuse() {
        KarmaRunConfiguration runConfiguration = (KarmaRunConfiguration)((Object)ObjectUtils.tryCast((Object)this.myEnvironment.getRunProfile(), KarmaRunConfiguration.class));
        if (runConfiguration != null) {
            WebBrowser browser = (WebBrowser)WEB_BROWSER_KEY.get((UserDataHolder)runConfiguration);
            if (!WebBrowserManager.getInstance().getActiveBrowsers().contains(browser)) {
                WEB_BROWSER_KEY.set((UserDataHolder)runConfiguration, null);
                return null;
            }
            return browser;
        }
        return null;
    }

    private void setWebBrowserToReuse(@Nullable WebBrowser browser) {
        KarmaRunConfiguration runConfiguration = (KarmaRunConfiguration)((Object)ObjectUtils.tryCast((Object)this.myEnvironment.getRunProfile(), KarmaRunConfiguration.class));
        if (runConfiguration != null) {
            WEB_BROWSER_KEY.set((UserDataHolder)runConfiguration, (Object)browser);
        }
    }

    private void printSupportedBrowsers(@NotNull List<DebuggableWebBrowser> allDebuggableActiveBrowsers, @NotNull List<DebuggableWebBrowser> capturedDebuggableActiveBrowsers) {
        if (allDebuggableActiveBrowsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDebuggableActiveBrowsers", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "printSupportedBrowsers"));
        }
        if (capturedDebuggableActiveBrowsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capturedDebuggableActiveBrowsers", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "printSupportedBrowsers"));
        }
        if (capturedDebuggableActiveBrowsers.isEmpty()) {
            if (allDebuggableActiveBrowsers.isEmpty()) {
                this.myConsoleView.print("No supported browsers found.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                this.myConsoleView.print("JavaScript debugging is currently supported in Chrome or Firefox.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                this.printVariants(allDebuggableActiveBrowsers);
            }
        } else {
            this.printVariants(capturedDebuggableActiveBrowsers);
        }
    }

    private void printVariants(@NotNull Collection<DebuggableWebBrowser> browsers) {
        if (browsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browsers", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector", "printVariants"));
        }
        this.myConsoleView.print("Debug karma tests in:\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        for (DebuggableWebBrowser browser : browsers) {
            this.myConsoleView.print(" * ", ConsoleViewContentType.SYSTEM_OUTPUT);
            this.myConsoleView.printHyperlink(browser.getWebBrowser().getName(), (HyperlinkInfo)new DebugHyperlinkInfo(browser.getWebBrowser()));
            this.myConsoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    private class DebugHyperlinkInfo
    implements HyperlinkInfo {
        private final WebBrowser myWebBrowser;

        public DebugHyperlinkInfo(WebBrowser webBrowser) {
            if (webBrowser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webBrowser", "com/intellij/javascript/karma/debug/KarmaDebugBrowserSelector$DebugHyperlinkInfo", "<init>"));
            }
            this.myWebBrowser = webBrowser;
        }

        public void navigate(Project project) {
            KarmaDebugBrowserSelector.this.setWebBrowserToReuse(this.myWebBrowser);
            ExecutionUtil.restart((ExecutionEnvironment)KarmaDebugBrowserSelector.this.myEnvironment);
        }
    }
}

