/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.debug;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.AsyncGenericProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.debug.DebuggableWebBrowser;
import com.intellij.javascript.karma.debug.KarmaDebugBrowserSelector;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import java.util.List;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventDataType;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

public class KarmaDebugProgramRunner
extends AsyncGenericProgramRunner {
    private static final Logger LOG = Logger.getInstance(KarmaDebugProgramRunner.class);

    @NotNull
    public String getRunnerId() {
        if ("KarmaJavaScriptTestRunnerDebug" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "getRunnerId"));
        }
        return "KarmaJavaScriptTestRunnerDebug";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "canRun"));
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof KarmaRunConfiguration;
    }

    @NotNull
    protected Promise<RunProfileStarter> prepare(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepare"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepare"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final ExecutionResult executionResult = state.execute(environment.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            Promise promise = Promise.resolve(null);
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepare"));
            }
            return promise;
        }
        final KarmaConsoleView consoleView = KarmaConsoleView.get(executionResult, state);
        if (consoleView == null) {
            Promise promise = Promise.resolve((Object)KarmaUtil.createDefaultRunProfileStarter(executionResult));
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepare"));
            }
            return promise;
        }
        final KarmaServer karmaServer = consoleView.getKarmaExecutionSession().getKarmaServer();
        if (karmaServer.areBrowsersReady()) {
            KarmaDebugBrowserSelector browserSelector = new KarmaDebugBrowserSelector(karmaServer.getCapturedBrowsers(), environment, (ConsoleView)consoleView);
            final DebuggableWebBrowser debuggableWebBrowser = browserSelector.selectDebugEngine();
            if (debuggableWebBrowser == null) {
                Promise promise = Promise.resolve((Object)KarmaUtil.createDefaultRunProfileStarter(executionResult));
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepare"));
                }
                return promise;
            }
            Promise<RunProfileStarter> promise = KarmaDebugProgramRunner.prepareDebugger(environment.getProject(), debuggableWebBrowser, new RunProfileStarter(){

                @Nullable
                public RunContentDescriptor execute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner$1", "execute"));
                    }
                    if (env == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner$1", "execute"));
                    }
                    final Url url = Urls.newFromEncoded((String)karmaServer.formatUrl("/debug.html"));
                    final DebuggableFileFinder fileFinder = KarmaDebugProgramRunner.getDebuggableFileFinder(karmaServer);
                    XDebugSession session = XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, new XDebugProcessStarter(){

                        @NotNull
                        public XDebugProcess start(@NotNull XDebugSession session) {
                            if (session == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner$1$1", "start"));
                            }
                            JavaScriptDebugEngine debugEngine = debuggableWebBrowser.getDebugEngine();
                            WebBrowser browser = debuggableWebBrowser.getWebBrowser();
                            JavaScriptDebugProcess debugProcess = debugEngine.createDebugProcess(session, browser, fileFinder, url, executionResult, true);
                            debugProcess.addFirstLineBreakpointPattern("\\.browserify$");
                            debugProcess.setElementsInspectorEnabled(false);
                            debugProcess.setLayouter((XDebugTabLayouter)consoleView.createDebugLayouter(debugProcess));
                            KarmaDebugProgramRunner.listenForCompletedMessage((JavaScriptDebugProcess<? extends VmConnection>)debugProcess, karmaServer);
                            JavaScriptDebugProcess javaScriptDebugProcess = debugProcess;
                            if (javaScriptDebugProcess == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner$1$1", "start"));
                            }
                            return javaScriptDebugProcess;
                        }
                    });
                    return session.getRunContentDescriptor();
                }
            });
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepare"));
            }
            return promise;
        }
        Promise promise = Promise.resolve((Object)new RunProfileStarter(){

            @Nullable
            public RunContentDescriptor execute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner$2", "execute"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner$2", "execute"));
                }
                RunContentDescriptor descriptor = KarmaUtil.createDefaultDescriptor(executionResult, env);
                karmaServer.onBrowsersReady(() -> ExecutionUtil.restartIfActive((RunContentDescriptor)descriptor));
                return descriptor;
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepare"));
        }
        return promise;
    }

    private static void listenForCompletedMessage(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess, @NotNull KarmaServer karmaServer) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "listenForCompletedMessage"));
        }
        if (karmaServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaServer", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "listenForCompletedMessage"));
        }
        String debugJsFileUrl = karmaServer.formatUrl("/debug.js");
        debugProcess.getConnection().stateChanged(state -> {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "lambda$listenForCompletedMessage$2"));
            }
            WipVm vm = (WipVm)ObjectUtils.tryCast((Object)debugProcess.getVm(), WipVm.class);
            if (vm != null) {
                vm.getCommandProcessor().getEventMap().add((EventType)ConsoleAPICalledEventData.TYPE, data -> {
                    CallFrameValue frame;
                    StackTraceValue trace;
                    if (debugProcess == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "lambda$null$1"));
                    }
                    if (data.type() == ConsoleAPICalledEventDataType.LOG && (trace = data.getStackTrace()) != null && (frame = (CallFrameValue)ContainerUtil.getFirstItem((List)trace.callFrames())) != null && "window.__karma__.complete".equals(frame.functionName()) && debugJsFileUrl.equals(frame.url())) {
                        new Alarm(Alarm.ThreadToUse.SWING_THREAD).addRequest(() -> {
                            if (debugProcess == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "lambda$null$0"));
                            }
                            debugProcess.getConnection().detachAndClose();
                        }, 500);
                    }
                    return Unit.INSTANCE;
                });
            }
            return Unit.INSTANCE;
        });
    }

    private static DebuggableFileFinder getDebuggableFileFinder(@NotNull KarmaServer karmaServer) {
        VirtualFile[] roots;
        VirtualFile basePath;
        if (karmaServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaServer", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "getDebuggableFileFinder"));
        }
        HashBiMap mappings = HashBiMap.create();
        KarmaConfig karmaConfig = karmaServer.getKarmaConfig();
        if (karmaConfig != null && (basePath = LocalFileSystem.getInstance().findFileByPath(karmaConfig.getBasePath())) != null && basePath.isValid()) {
            if (karmaConfig.isWebpack()) {
                mappings.put((Object)("webpack:///" + basePath.getPath()), (Object)basePath);
                VirtualFile nodeModulesDir = basePath.findChild("node_modules");
                if (nodeModulesDir != null && nodeModulesDir.isValid() && nodeModulesDir.isDirectory()) {
                    mappings.put((Object)karmaServer.formatUrlWithoutUrlRoot("/base/node_modules"), (Object)nodeModulesDir);
                }
            } else {
                mappings.put((Object)karmaServer.formatUrlWithoutUrlRoot("/base"), (Object)basePath);
            }
        }
        if (SystemInfo.isWindows) {
            for (VirtualFile root : roots = ManagingFS.getInstance().getLocalRoots()) {
                String key = karmaServer.formatUrlWithoutUrlRoot("/absolute" + root.getName());
                if (mappings.containsKey((Object)key)) {
                    LOG.warn("Duplicate mapping for Karma debug: " + key);
                    continue;
                }
                mappings.put((Object)key, (Object)root);
            }
        } else {
            roots = ManagingFS.getInstance().getLocalRoots();
            if (roots.length == 1) {
                mappings.put((Object)karmaServer.formatUrlWithoutUrlRoot("/absolute"), (Object)roots[0]);
            }
        }
        return new RemoteDebuggingFileFinder((BiMap)mappings, null);
    }

    public static Promise<RunProfileStarter> prepareDebugger(@NotNull Project project, @NotNull DebuggableWebBrowser debuggableWebBrowser, @NotNull RunProfileStarter starter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepareDebugger"));
        }
        if (debuggableWebBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggableWebBrowser", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepareDebugger"));
        }
        if (starter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "starter", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "prepareDebugger"));
        }
        return debuggableWebBrowser.getDebugEngine().prepareDebugger(project, debuggableWebBrowser.getWebBrowser()).then(aVoid -> {
            if (starter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "starter", "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner", "lambda$prepareDebugger$3"));
            }
            return starter;
        });
    }
}

