/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.javascript.debugger.JSDebugTabLayouter;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.karma.execution.KarmaExecutionSession;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerLogComponent;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;

public class KarmaConsoleView
extends SMTRunnerConsoleView
implements ExecutionConsoleEx {
    private static final Logger LOG = Logger.getInstance(KarmaConsoleView.class);
    private final KarmaServer myServer;
    private final KarmaExecutionSession myExecutionSession;

    public KarmaConsoleView(@NotNull TestConsoleProperties consoleProperties, @NotNull KarmaServer server, @NotNull KarmaExecutionSession executionSession) {
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/intellij/javascript/karma/execution/KarmaConsoleView", "<init>"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/execution/KarmaConsoleView", "<init>"));
        }
        if (executionSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionSession", "com/intellij/javascript/karma/execution/KarmaConsoleView", "<init>"));
        }
        super(consoleProperties);
        this.myServer = server;
        this.myExecutionSession = executionSession;
    }

    public void buildUi(RunnerLayoutUi ui) {
        this.registerConsoleContent(ui);
        this.registerKarmaServerTab(ui);
    }

    @Nullable
    public String getExecutionConsoleId() {
        return null;
    }

    @NotNull
    private Content registerConsoleContent(@NotNull RunnerLayoutUi ui) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/javascript/karma/execution/KarmaConsoleView", "registerConsoleContent"));
        }
        ui.getOptions().setMinimizeActionEnabled(false);
        Content consoleContent = ui.createContent("ConsoleContent", this.getComponent(), "Test Run", AllIcons.Debugger.Console, this.getPreferredFocusableComponent());
        ui.addContent(consoleContent, 1, PlaceInGrid.bottom, false);
        consoleContent.setCloseable(false);
        final KarmaRootTestProxyFormatter rootFormatter = new KarmaRootTestProxyFormatter(this, this.myServer, this.myExecutionSession.isDebug());
        if (this.myServer.areBrowsersReady()) {
            KarmaUtil.selectAndFocusIfNotDisposed(ui, consoleContent, false, false);
        } else {
            this.myServer.onPortBound(() -> {
                if (ui == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/javascript/karma/execution/KarmaConsoleView", "lambda$registerConsoleContent$0"));
                }
                KarmaUtil.selectAndFocusIfNotDisposed(ui, consoleContent, false, false);
                this.scheduleBrowserCapturingSuggestion();
            });
        }
        final ProcessAdapter listener = new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                if (KarmaConsoleView.this.myServer.getProcessHandler().isProcessTerminated()) {
                    rootFormatter.onServerProcessTerminated();
                    KarmaConsoleView.this.printServerFinishedInfo();
                }
                rootFormatter.onTestRunProcessTerminated();
            }
        };
        this.myExecutionSession.getProcessHandler().addProcessListener((ProcessListener)listener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                KarmaConsoleView.this.myExecutionSession.getProcessHandler().removeProcessListener((ProcessListener)listener);
            }
        });
        Content content = consoleContent;
        if (content == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaConsoleView", "registerConsoleContent"));
        }
        return content;
    }

    private void scheduleBrowserCapturingSuggestion() {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        alarm.addRequest(() -> {
            if (!(this.myServer.getProcessHandler().isProcessTerminated() || this.myServer.areBrowsersReady() || Disposer.isDisposed((Disposable)this))) {
                this.printBrowserCapturingSuggestion();
            }
            Disposer.dispose((Disposable)alarm);
        }, 1000, ModalityState.any());
    }

    private void printBrowserCapturingSuggestion() {
        SMTestProxy.SMRootTestProxy rootNode = this.getResultsViewer().getTestsRootNode();
        rootNode.addLast(printer -> {
            printer.print("To capture a browser open ", ConsoleViewContentType.SYSTEM_OUTPUT);
            String url = this.myServer.formatUrl("/");
            printer.printHyperlink(url, (HyperlinkInfo)new OpenUrlHyperlinkInfo(url));
            printer.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        });
    }

    private void printServerFinishedInfo() {
        SMTestProxy.SMRootTestProxy rootNode = this.getResultsViewer().getTestsRootNode();
        rootNode.addSystemOutput("Karma server process terminated");
    }

    private void registerKarmaServerTab(@NotNull RunnerLayoutUi ui) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/javascript/karma/execution/KarmaConsoleView", "registerKarmaServerTab"));
        }
        KarmaServerLogComponent.register(this.getProperties().getProject(), this.myServer, ui, true);
    }

    @NotNull
    public KarmaExecutionSession getKarmaExecutionSession() {
        KarmaExecutionSession karmaExecutionSession = this.myExecutionSession;
        if (karmaExecutionSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaConsoleView", "getKarmaExecutionSession"));
        }
        return karmaExecutionSession;
    }

    public JSDebugTabLayouter createDebugLayouter(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/karma/execution/KarmaConsoleView", "createDebugLayouter"));
        }
        return new KarmaDebugTabLayouter(debugProcess);
    }

    @Nullable
    public static KarmaConsoleView get(@NotNull ExecutionResult result, @NotNull RunProfileState state) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/karma/execution/KarmaConsoleView", "get"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/karma/execution/KarmaConsoleView", "get"));
        }
        ExecutionConsole console = result.getExecutionConsole();
        if (console instanceof KarmaConsoleView) {
            return (KarmaConsoleView)console;
        }
        Class<?> consoleClass = console != null ? console.getClass() : null;
        LOG.info("Cannot cast " + consoleClass + " to " + KarmaConsoleView.class.getSimpleName() + ", RunProfileState: " + state.getClass().getName());
        return null;
    }

    private class KarmaDebugTabLayouter
    extends JSDebugTabLayouter {
        public KarmaDebugTabLayouter(JavaScriptDebugProcess<? extends VmConnection> debugProcess) {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaDebugTabLayouter", "<init>"));
            }
            super(debugProcess);
        }

        @NotNull
        public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaDebugTabLayouter", "registerConsoleContent"));
            }
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaDebugTabLayouter", "registerConsoleContent"));
            }
            Content content = KarmaConsoleView.this.registerConsoleContent(ui);
            if (content == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaDebugTabLayouter", "registerConsoleContent"));
            }
            return content;
        }

        public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaDebugTabLayouter", "registerAdditionalContent"));
            }
            super.registerAdditionalContent(ui);
            KarmaConsoleView.this.registerKarmaServerTab(ui);
        }
    }

    private static class KarmaRootTestProxyFormatter
    implements SMRootTestProxyFormatter {
        private final KarmaServer myServer;
        private final TestTreeView myTreeView;
        private final boolean myDebug;
        private boolean myTestRunProcessTerminated;
        private boolean myServerProcessTerminated;

        private KarmaRootTestProxyFormatter(@NotNull SMTRunnerConsoleView consoleView, @NotNull KarmaServer server, boolean debug) {
            TestTreeRenderer originalRenderer;
            if (consoleView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaRootTestProxyFormatter", "<init>"));
            }
            if (server == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaRootTestProxyFormatter", "<init>"));
            }
            this.myTestRunProcessTerminated = false;
            this.myServerProcessTerminated = false;
            this.myTreeView = consoleView.getResultsViewer().getTreeView();
            this.myServer = server;
            this.myDebug = debug;
            if (this.myTreeView != null && (originalRenderer = (TestTreeRenderer)ObjectUtils.tryCast((Object)this.myTreeView.getCellRenderer(), TestTreeRenderer.class)) != null) {
                originalRenderer.setAdditionalRootFormatter((SMRootTestProxyFormatter)this);
            }
        }

        private static void render(@NotNull TestTreeRenderer renderer, @NotNull String msg, boolean error) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaRootTestProxyFormatter", "render"));
            }
            if (msg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaRootTestProxyFormatter", "render"));
            }
            renderer.clear();
            if (error) {
                renderer.setIcon(PoolOfTestIcons.TERMINATED_ICON);
            }
            renderer.append(msg);
        }

        public void format(@NotNull SMTestProxy.SMRootTestProxy testProxy, @NotNull TestTreeRenderer renderer) {
            if (testProxy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testProxy", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaRootTestProxyFormatter", "format"));
            }
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaRootTestProxyFormatter", "format"));
            }
            if (testProxy.isLeaf()) {
                if (this.myServerProcessTerminated) {
                    KarmaRootTestProxyFormatter.render(renderer, "Server is dead", true);
                } else if (this.myDebug) {
                    KarmaRootTestProxyFormatter.render(renderer, "Test tree is not available in a debug session", false);
                } else if (this.myTestRunProcessTerminated) {
                    KarmaRootTestProxyFormatter.render(renderer, "Aborted", true);
                } else if (this.myServer.isPortBound() && !this.myServer.areBrowsersReady()) {
                    KarmaRootTestProxyFormatter.render(renderer, "Waiting for browser capturing...", false);
                }
            }
        }

        private void onTestRunProcessTerminated() {
            this.myTestRunProcessTerminated = true;
            this.myTreeView.repaint();
        }

        private void onServerProcessTerminated() {
            this.myServerProcessTerminated = true;
            this.myTreeView.repaint();
        }
    }
}

