/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaExecutionType;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.execution.KarmaTestLocationProvider;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.javascript.karma.tree.KarmaTestProxyFilterProvider;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.config.AbstractProperty;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaExecutionSession {
    private static final String FRAMEWORK_NAME = "KarmaJavaScriptTestRunner";
    private final Project myProject;
    private final KarmaRunConfiguration myRunConfiguration;
    private final Executor myExecutor;
    private final KarmaServer myKarmaServer;
    private final KarmaRunSettings myRunSettings;
    private final SMTRunnerConsoleView mySmtConsoleView;
    private final ProcessHandler myProcessHandler;
    private final KarmaExecutionType myExecutionType;

    public KarmaExecutionSession(@NotNull Project project, @NotNull KarmaRunConfiguration runConfiguration, @NotNull Executor executor, @NotNull KarmaServer karmaServer, @NotNull KarmaRunSettings runSettings, @NotNull KarmaExecutionType executionType) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "<init>"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "<init>"));
        }
        if (karmaServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaServer", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "<init>"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "<init>"));
        }
        if (executionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionType", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "<init>"));
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myExecutor = executor;
        this.myKarmaServer = karmaServer;
        this.myRunSettings = runSettings;
        this.mySmtConsoleView = this.createSMTRunnerConsoleView();
        this.myExecutionType = executionType;
        this.myProcessHandler = this.createProcessHandler(karmaServer);
    }

    @NotNull
    private SMTRunnerConsoleView createSMTRunnerConsoleView() {
        KarmaTestProxyFilterProvider filterProvider = new KarmaTestProxyFilterProvider(this.myProject, this.myKarmaServer);
        KarmaConsoleProperties testConsoleProperties = new KarmaConsoleProperties(this.myRunConfiguration, this.myExecutor, filterProvider);
        KarmaConsoleView consoleView = new KarmaConsoleView((TestConsoleProperties)testConsoleProperties, this.myKarmaServer, this);
        Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
        SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView, (String)FRAMEWORK_NAME);
        KarmaConsoleView karmaConsoleView = consoleView;
        if (karmaConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createSMTRunnerConsoleView"));
        }
        return karmaConsoleView;
    }

    public boolean isDebug() {
        return this.myExecutionType == KarmaExecutionType.DEBUG;
    }

    @NotNull
    private ProcessHandler createProcessHandler(@NotNull KarmaServer server) throws ExecutionException {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createProcessHandler"));
        }
        if (!this.isDebug()) {
            File clientAppFile;
            try {
                clientAppFile = server.getKarmaJsSourcesLocator().getClientAppFile();
            }
            catch (IOException e) {
                throw new ExecutionException("Can't find karma-intellij test runner", (Throwable)e);
            }
            if (server.areBrowsersReady()) {
                OSProcessHandler oSProcessHandler = this.createOSProcessHandler(server, clientAppFile);
                if (oSProcessHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createProcessHandler"));
                }
                return oSProcessHandler;
            }
        }
        NopProcessHandler nopProcessHandler = new NopProcessHandler();
        KarmaExecutionSession.terminateOnServerShutdown(server, (ProcessHandler)nopProcessHandler);
        NopProcessHandler nopProcessHandler2 = nopProcessHandler;
        if (nopProcessHandler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createProcessHandler"));
        }
        return nopProcessHandler2;
    }

    private static void terminateOnServerShutdown(final @NotNull KarmaServer server, final @NotNull ProcessHandler processHandler) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "terminateOnServerShutdown"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "terminateOnServerShutdown"));
        }
        final KarmaServerTerminatedListener terminationCallback = new KarmaServerTerminatedListener(){

            @Override
            public void onTerminated(int exitCode) {
                processHandler.destroyProcess();
            }
        };
        server.onTerminated(terminationCallback);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                server.removeTerminatedListener(terminationCallback);
            }
        });
    }

    @NotNull
    private OSProcessHandler createOSProcessHandler(@NotNull KarmaServer server, @NotNull File clientAppFile) throws ExecutionException {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createOSProcessHandler"));
        }
        if (clientAppFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientAppFile", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createOSProcessHandler"));
        }
        NodeJsLocalInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveAsLocal(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, server.getServerPort(), server.getKarmaConfig(), clientAppFile);
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
        server.getRestarter().onRunnerExecutionStarted((OSProcessHandler)processHandler);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        this.mySmtConsoleView.attachToProcess((ProcessHandler)processHandler);
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createOSProcessHandler"));
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, int serverPort, @Nullable KarmaConfig config, @NotNull File clientAppFile) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createCommandLine"));
        }
        if (clientAppFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientAppFile", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        File configFile = new File(this.myRunSettings.getConfigPath());
        commandLine.setWorkDirectory(configFile.getParentFile());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        commandLine.addParameter(clientAppFile.getAbsolutePath());
        commandLine.addParameter("--karmaPackageDir=" + this.myKarmaServer.getKarmaJsSourcesLocator().getKarmaPackageDir());
        commandLine.addParameter("--serverPort=" + serverPort);
        if (config != null) {
            commandLine.addParameter("--urlRoot=" + config.getUrlRoot());
        }
        if (this.isDebug()) {
            commandLine.addParameter("--debug=true");
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "getProcessHandler"));
        }
        return processHandler;
    }

    @NotNull
    public KarmaServer getKarmaServer() {
        KarmaServer karmaServer = this.myKarmaServer;
        if (karmaServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "getKarmaServer"));
        }
        return karmaServer;
    }

    @NotNull
    public SMTRunnerConsoleView getSmtConsoleView() {
        SMTRunnerConsoleView sMTRunnerConsoleView = this.mySmtConsoleView;
        if (sMTRunnerConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaExecutionSession", "getSmtConsoleView"));
        }
        return sMTRunnerConsoleView;
    }

    private static class KarmaConsoleProperties
    extends SMTRunnerConsoleProperties {
        private final KarmaTestProxyFilterProvider myFilterProvider;

        public KarmaConsoleProperties(KarmaRunConfiguration configuration, Executor executor, KarmaTestProxyFilterProvider filterProvider) {
            super((RunConfiguration)configuration, KarmaExecutionSession.FRAMEWORK_NAME, executor);
            this.myFilterProvider = filterProvider;
            this.setUsePredefinedMessageFilter(true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
            this.setIdBasedTestTree(true);
            this.setPrintTestingStartedTime(false);
        }

        public SMTestLocator getTestLocator() {
            return KarmaTestLocationProvider.INSTANCE;
        }

        public TestProxyFilterProvider getFilterProvider() {
            return this.myFilterProvider;
        }
    }
}

