/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class KarmaProjectSettings {
    private static final String KARMA_PACKAGE_DIR__KEY = "javascript.karma.karma_node_package_dir";
    private static final Key<KarmaProjectSettings> SETTINGS_KEY = Key.create((String)"KARMA_SETTINGS_KEY");
    private final String myKarmaPackageDir;

    public KarmaProjectSettings(@NotNull String karmaPackageDir) {
        if (karmaPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaPackageDir", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "<init>"));
        }
        this.myKarmaPackageDir = karmaPackageDir;
    }

    @NotNull
    public String getKarmaPackageDir() {
        String string = this.myKarmaPackageDir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "getKarmaPackageDir"));
        }
        return string;
    }

    @NotNull
    public static String getKarmaPackageDir(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "getKarmaPackageDir"));
        }
        String string = KarmaProjectSettings.get(project).getKarmaPackageDir();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "getKarmaPackageDir"));
        }
        return string;
    }

    public static void setKarmaPackageDir(@NotNull Project project, @NotNull String karmaPackageDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "setKarmaPackageDir"));
        }
        if (karmaPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaPackageDir", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "setKarmaPackageDir"));
        }
        KarmaProjectSettings.setProjectSetting(project, KARMA_PACKAGE_DIR__KEY, karmaPackageDir);
        SETTINGS_KEY.set((UserDataHolder)project, null);
    }

    @NotNull
    private static KarmaProjectSettings get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "get"));
        }
        KarmaProjectSettings settings = (KarmaProjectSettings)SETTINGS_KEY.get((UserDataHolder)project);
        if (settings != null) {
            KarmaProjectSettings karmaProjectSettings = settings;
            if (karmaProjectSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "get"));
            }
            return karmaProjectSettings;
        }
        String karmaPackageDir = KarmaProjectSettings.doGetKarmaPackageDir(project);
        settings = new KarmaProjectSettings(karmaPackageDir);
        SETTINGS_KEY.set((UserDataHolder)project, (Object)settings);
        KarmaProjectSettings karmaProjectSettings = settings;
        if (karmaProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "get"));
        }
        return karmaProjectSettings;
    }

    @NotNull
    private static String doGetKarmaPackageDir(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "doGetKarmaPackageDir"));
        }
        String string = KarmaProjectSettings.getProjectSetting(project, KARMA_PACKAGE_DIR__KEY);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "doGetKarmaPackageDir"));
        }
        return string;
    }

    @NotNull
    private static String getProjectSetting(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "getProjectSetting"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "getProjectSetting"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        String string = StringUtil.notNullize((String)propertiesComponent.getValue(key));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "getProjectSetting"));
        }
        return string;
    }

    private static void setProjectSetting(@NotNull Project project, @NotNull String key, @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "setProjectSetting"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "setProjectSetting"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/karma/execution/KarmaProjectSettings", "setProjectSetting"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        propertiesComponent.setValue(key, value);
    }
}

