/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.karma.execution.KarmaConfigurationType;
import com.intellij.javascript.karma.execution.KarmaProjectSettings;
import com.intellij.javascript.karma.execution.KarmaRunConfigurationEditor;
import com.intellij.javascript.karma.execution.KarmaRunConfigurationRefactoringHandler;
import com.intellij.javascript.karma.execution.KarmaRunProfileState;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.execution.KarmaRunSettingsSerializationUtil;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.ObjectUtils;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunConfiguration
extends LocatableConfigurationBase
implements RefactoringListenerProvider,
PreferableRunConfiguration {
    private static final Logger LOG = Logger.getInstance(KarmaRunConfiguration.class);
    private KarmaRunSettings myRunSettings;

    protected KarmaRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "<init>"));
        }
        super(project, factory, name);
        this.myRunSettings = new KarmaRunSettings.Builder().build();
    }

    @NotNull
    public KarmaRunConfigurationEditor getConfigurationEditor() {
        KarmaRunConfigurationEditor karmaRunConfigurationEditor = new KarmaRunConfigurationEditor(this.getProject());
        if (karmaRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "getConfigurationEditor"));
        }
        return karmaRunConfigurationEditor;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunSettings = KarmaRunSettingsSerializationUtil.readXml(element);
        String karmaPackageDir = this.myRunSettings.getKarmaPackageDir();
        if ("true".equals(element.getAttributeValue("default")) && karmaPackageDir != null && karmaPackageDir.isEmpty()) {
            this.myRunSettings = this.myRunSettings.builder().setKarmaPackageDir(null).build();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        KarmaRunSettingsSerializationUtil.writeXml(element, this.myRunSettings);
    }

    @NotNull
    public String getKarmaPackageDir() {
        if (this.isTemplate()) {
            String string = StringUtil.notNullize((String)this.myRunSettings.getKarmaPackageDir());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "getKarmaPackageDir"));
            }
            return string;
        }
        String karmaPackageDir = this.getOrInitKarmaPackageDir();
        if (StringUtil.isNotEmpty((String)karmaPackageDir)) {
            String string = karmaPackageDir;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "getKarmaPackageDir"));
            }
            return string;
        }
        String string = KarmaProjectSettings.getKarmaPackageDir(this.getProject());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "getKarmaPackageDir"));
        }
        return string;
    }

    @NotNull
    private String getOrInitKarmaPackageDir() {
        if (this.myRunSettings.getKarmaPackageDir() == null) {
            Project project = this.getProject();
            String karmaPackageDir = KarmaUtil.detectKarmaPackageDir(project, this.myRunSettings.getConfigPath(), this.myRunSettings.getInterpreterRef());
            if (StringUtil.isNotEmpty((String)(karmaPackageDir = StringUtil.notNullize((String)karmaPackageDir))) && !KarmaUtil.isPathUnderContentRoots(project, karmaPackageDir)) {
                String projectKarmaPackageDir = KarmaProjectSettings.getKarmaPackageDir(project);
                if (StringUtil.isEmpty((String)projectKarmaPackageDir)) {
                    KarmaProjectSettings.setKarmaPackageDir(project, karmaPackageDir);
                }
                karmaPackageDir = "";
            }
            this.myRunSettings = this.myRunSettings.builder().setKarmaPackageDir(karmaPackageDir).build();
        }
        String string = (String)ObjectUtils.assertNotNull((Object)this.myRunSettings.getKarmaPackageDir());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "getOrInitKarmaPackageDir"));
        }
        return string;
    }

    private boolean isTemplate() {
        return KarmaRunConfiguration.getTemplateRunConfiguration(this.getProject()) == this;
    }

    @Nullable
    private static KarmaRunConfiguration getTemplateRunConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "getTemplateRunConfiguration"));
        }
        if (project.isDisposed()) {
            return null;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings templateSettings = runManager.getConfigurationTemplate(KarmaConfigurationType.getFactory());
        RunConfiguration rc = templateSettings.getConfiguration();
        if (rc instanceof KarmaRunConfiguration) {
            return (KarmaRunConfiguration)rc;
        }
        LOG.warn("No Karma template run configuration found: " + rc);
        return null;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "getState"));
        }
        String karmaPackageDir = this.getKarmaPackageDir();
        return new KarmaRunProfileState(this.getProject(), this, env, karmaPackageDir);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.check(this.getKarmaPackageDir());
    }

    private void check(@NotNull String karmaPackageDirPath) throws RuntimeConfigurationException {
        if (karmaPackageDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaPackageDirPath", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "check"));
        }
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolve(this.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        if (StringUtil.isEmpty((String)karmaPackageDirPath)) {
            throw new RuntimeConfigurationError("Please specify Karma package path");
        }
        File karmaPackageDir = new File(karmaPackageDirPath);
        if (!karmaPackageDir.isDirectory() || !karmaPackageDir.isAbsolute()) {
            throw new RuntimeConfigurationError("Please specify Karma package path correctly");
        }
        String configPath = this.myRunSettings.getConfigPath();
        if (configPath.trim().isEmpty()) {
            throw new RuntimeConfigurationError("Please specify config file path");
        }
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            throw new RuntimeConfigurationError("Configuration file does not exist");
        }
        if (!configFile.isFile()) {
            throw new RuntimeConfigurationError("Please specify config file path correctly");
        }
    }

    @NotNull
    public KarmaRunSettings getRunSettings() {
        KarmaRunSettings karmaRunSettings = this.myRunSettings;
        if (karmaRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "getRunSettings"));
        }
        return karmaRunSettings;
    }

    public void setRunSettings(@NotNull KarmaRunSettings runSettings) {
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "setRunSettings"));
        }
        String newKarmaPackageDir = StringUtil.notNullize((String)runSettings.getKarmaPackageDir());
        String oldKarmaPackageDir = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)this.myRunSettings.getKarmaPackageDir()));
        if (FileUtil.toSystemDependentName((String)newKarmaPackageDir).equals(oldKarmaPackageDir)) {
            this.myRunSettings = runSettings;
            return;
        }
        Project project = this.getProject();
        if (!KarmaUtil.isPathUnderContentRoots(project, newKarmaPackageDir)) {
            KarmaProjectSettings.setKarmaPackageDir(project, newKarmaPackageDir);
            newKarmaPackageDir = "";
        }
        if (newKarmaPackageDir.isEmpty() && this.isTemplate()) {
            newKarmaPackageDir = null;
        }
        this.myRunSettings = runSettings.builder().setKarmaPackageDir(newKarmaPackageDir).build();
    }

    public void setConfigFilePath(@NotNull String configFilePath) {
        if (configFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePath", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "setConfigFilePath"));
        }
        this.myRunSettings = this.myRunSettings.builder().setConfigPath(configFilePath).build();
    }

    public String suggestedName() {
        File file = new File(this.myRunSettings.getConfigPath());
        return file.getName();
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return KarmaRunConfigurationRefactoringHandler.getRefactoringElementListener(this, element);
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        VirtualFile virtualFile;
        if (otherRc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherRc", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "isPreferredOver"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/javascript/karma/execution/KarmaRunConfiguration", "isPreferredOver"));
        }
        PsiFile psiFile = (PsiFile)ObjectUtils.tryCast((Object)sourceElement, PsiFile.class);
        if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            return KarmaUtil.isKarmaConfigFile(virtualFile.getNameSequence(), true);
        }
        return false;
    }
}

