/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.karma.KarmaBundle;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunConfigurationEditor
extends SettingsEditor<KarmaRunConfiguration> {
    private final Project myProject;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final TextFieldWithHistoryWithBrowseButton myKarmaPackageDirPathTextFieldWithBrowseButton;
    private final TextFieldWithHistoryWithBrowseButton myConfigPathTextFieldWithBrowseButton;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JTextField myBrowsers;
    private final JPanel myRootComponent;

    public KarmaRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "<init>"));
        }
        this.myProject = project;
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myKarmaPackageDirPathTextFieldWithBrowseButton = this.createKarmaPackageDirPathTextField(project);
        this.myConfigPathTextFieldWithBrowseButton = KarmaRunConfigurationEditor.createConfigurationFileTextField(project);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myBrowsers = KarmaRunConfigurationEditor.createBrowsersTextField();
        JComponent browsersDescription = KarmaRunConfigurationEditor.createBrowsersDescription();
        this.myRootComponent = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent(KarmaBundle.message("runConfiguration.config_file.label", new Object[0]), (JComponent)this.myConfigPathTextFieldWithBrowseButton).addLabeledComponent(KarmaBundle.message("runConfiguration.browsers.label", new Object[0]), (JComponent)this.myBrowsers).addLabeledComponent("", browsersDescription, 0, false).addComponent((JComponent)new JSeparator(), 8).addLabeledComponent(KarmaBundle.message("runConfiguration.node_interpreter.label", new Object[0]), (JComponent)this.myNodeInterpreterField, 8).addLabeledComponent(KarmaBundle.message("runConfiguration.karma_package_dir.label", new Object[0]), (JComponent)this.myKarmaPackageDirPathTextFieldWithBrowseButton).addLabeledComponent(KarmaBundle.message("runConfiguration.environment.label", new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
    }

    @NotNull
    private static JComponent createBrowsersDescription() {
        Color fgColor = UIUtil.getLabelDisabledForeground();
        JEditorPane editorPane = SwingHelper.createHtmlViewer((boolean)true, (Font)UIUtil.getTitledBorderFont(), null, (Color)fgColor);
        SwingHelper.setHtml((JEditorPane)editorPane, (String)"overrides <i>browsers</i> setting from the configuration file", (Color)fgColor);
        JPanel panel = SwingHelper.wrapWithHorizontalStretch((JComponent)editorPane);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "createBrowsersDescription"));
        }
        return jPanel;
    }

    @NotNull
    private static JTextField createBrowsersTextField() {
        JBTextField browsers = new JBTextField();
        StatusText emptyStatusText = browsers.getEmptyText();
        emptyStatusText.setText("comma-separated list of browsers (e.g. Chrome,ChromeCanary,Firefox)");
        JBTextField jBTextField = browsers;
        if (jBTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "createBrowsersTextField"));
        }
        return jBTextField;
    }

    private TextFieldWithHistoryWithBrowseButton createKarmaPackageDirPathTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "createKarmaPackageDirPathTextField"));
        }
        TextFieldWithHistoryWithBrowseButton karmaPackageDirPathComponent = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)karmaPackageDirPathComponent.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            NodeJsLocalInterpreter interpreter = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)this.myNodeInterpreterField.getInterpreter());
            ArrayList modules = ContainerUtil.newArrayList();
            VirtualFile requester = KarmaUtil.getRequester(this.myProject, ((TextFieldWithHistory)this.myConfigPathTextFieldWithBrowseButton.getChildComponent()).getText());
            NodeModuleSearchUtil.findModulesWithName((List)modules, (String)"karma", (VirtualFile)requester, (NodeSettings)NodeSettings.create((NodeJsLocalInterpreter)interpreter), (boolean)true);
            ArrayList moduleDirs = ContainerUtil.newArrayListWithCapacity((int)modules.size());
            for (CompletionModuleInfo module : modules) {
                VirtualFile dir = module.getVirtualFile();
                if (dir == null || !dir.isDirectory()) continue;
                moduleDirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
            }
            Collections.sort(moduleDirs);
            return moduleDirs;
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)karmaPackageDirPathComponent, (String)KarmaBundle.message("runConfiguration.karma_package_dir.browse_dialog.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        return karmaPackageDirPathComponent;
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "createConfigurationFileTextField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "lambda$createConfigurationFileTextField$2"));
            }
            List<VirtualFile> newFiles = KarmaUtil.listPossibleConfigFilesInProject(project);
            List newFilePaths = ContainerUtil.map(newFiles, file -> FileUtil.toSystemDependentName((String)file.getPath()));
            Collections.sort(newFilePaths);
            return newFilePaths;
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (String)KarmaBundle.message("runConfiguration.config_file.browse_dialog.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "createConfigurationFileTextField"));
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    protected void resetEditorFrom(@NotNull KarmaRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "resetEditorFrom"));
        }
        KarmaRunSettings runSettings = runConfiguration.getRunSettings();
        this.myNodeInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        String karmaPackageDir = FileUtil.toSystemDependentName((String)runConfiguration.getKarmaPackageDir());
        KarmaRunConfigurationEditor.setTextAndAddToHistory((TextFieldWithHistory)this.myKarmaPackageDirPathTextFieldWithBrowseButton.getChildComponent(), karmaPackageDir);
        String configFilePath = FileUtil.toSystemDependentName((String)runSettings.getConfigPath());
        KarmaRunConfigurationEditor.setTextAndAddToHistory((TextFieldWithHistory)this.myConfigPathTextFieldWithBrowseButton.getChildComponent(), configFilePath);
        this.myBrowsers.setText(runSettings.getBrowsers());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myRootComponent);
        if (dialogWrapper instanceof SingleConfigurableEditor) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myKarmaPackageDirPathTextFieldWithBrowseButton);
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myConfigPathTextFieldWithBrowseButton);
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.any());
        }
    }

    private static void setTextAndAddToHistory(@NotNull TextFieldWithHistory textFieldWithHistory, @Nullable String text) {
        if (textFieldWithHistory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFieldWithHistory", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "setTextAndAddToHistory"));
        }
        textFieldWithHistory.setText(text);
        textFieldWithHistory.getModel().setSelectedItem(text);
        textFieldWithHistory.addCurrentTextToHistory();
    }

    protected void applyEditorTo(@NotNull KarmaRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "applyEditorTo"));
        }
        KarmaRunSettings.Builder builder = new KarmaRunSettings.Builder();
        builder.setConfigPath(((TextFieldWithHistory)this.myConfigPathTextFieldWithBrowseButton.getChildComponent()).getText());
        builder.setBrowsers(StringUtil.notNullize((String)this.myBrowsers.getText()));
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        builder.setKarmaPackageDir(((TextFieldWithHistory)this.myKarmaPackageDirPathTextFieldWithBrowseButton.getChildComponent()).getText());
        runConfiguration.setRunSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }
}

