/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.karma.execution.KarmaConfigurationType;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunConfigurationProducer
extends RunConfigurationProducer<KarmaRunConfiguration> {
    public KarmaRunConfigurationProducer() {
        super((ConfigurationType)KarmaConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(KarmaRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            return false;
        }
        RunConfiguration original = context.getOriginalConfiguration(null);
        if (original != null && !ConfigurationTypeUtil.equals((ConfigurationType)original.getType(), (ConfigurationType)KarmaConfigurationType.getInstance())) {
            return false;
        }
        JSFile jsFile = KarmaRunConfigurationProducer.getConfigJsFile(context.getLocation());
        if (jsFile == null) {
            return false;
        }
        VirtualFile configVirtualFile = jsFile.getVirtualFile();
        if (configVirtualFile == null) {
            return false;
        }
        sourceElement.set((Object)jsFile);
        KarmaRunConfigurationProducer.setupKarmaConfiguration(configuration, configVirtualFile);
        return true;
    }

    private static void setupKarmaConfiguration(@NotNull KarmaRunConfiguration configuration, @NotNull VirtualFile configVirtualFile) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/karma/execution/KarmaRunConfigurationProducer", "setupKarmaConfiguration"));
        }
        if (configVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configVirtualFile", "com/intellij/javascript/karma/execution/KarmaRunConfigurationProducer", "setupKarmaConfiguration"));
        }
        configuration.setConfigFilePath(configVirtualFile.getPath());
        String name = configuration.suggestedName();
        configuration.setName(name);
    }

    public boolean isConfigurationFromContext(KarmaRunConfiguration configuration, ConfigurationContext context) {
        if (configuration == null) {
            return false;
        }
        VirtualFile contextConfigVirtualFile = KarmaRunConfigurationProducer.getConfigFileFromContext(context);
        if (contextConfigVirtualFile == null) {
            return false;
        }
        String contextConfigFilePath = FileUtil.toSystemDependentName((String)contextConfigVirtualFile.getPath());
        String candidateConfigFilePath = FileUtil.toSystemDependentName((String)configuration.getRunSettings().getConfigPath());
        return contextConfigFilePath.equals(candidateConfigFilePath);
    }

    @Nullable
    private static VirtualFile getConfigFileFromContext(@Nullable ConfigurationContext context) {
        if (context == null) {
            return null;
        }
        JSFile jsFile = KarmaRunConfigurationProducer.getConfigJsFile(context.getLocation());
        if (jsFile == null) {
            return null;
        }
        return jsFile.getVirtualFile();
    }

    @Nullable
    private static JSFile getConfigJsFile(@Nullable Location location) {
        if (location == null) {
            return null;
        }
        PsiElement element = location.getPsiElement();
        JSFile jsFile = element instanceof PsiFile ? (JSFile)ObjectUtils.tryCast((Object)element, JSFile.class) : (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        if (jsFile != null && KarmaUtil.isKarmaConfigFile(jsFile.getName(), false)) {
            return jsFile;
        }
        return null;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        PreferableRunConfiguration otherRc;
        PsiFile psiFile = self.getSourceElement().getContainingFile();
        return psiFile == null || other == null || (otherRc = (PreferableRunConfiguration)ObjectUtils.tryCast((Object)other.getConfiguration(), PreferableRunConfiguration.class)) == null || !otherRc.isPreferredOver(self.getConfiguration(), (PsiElement)psiFile);
    }
}

