/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunConfigurationRefactoringHandler {
    @Nullable
    public static RefactoringElementListener getRefactoringElementListener(@NotNull KarmaRunConfiguration configuration, @Nullable PsiElement element) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/karma/execution/KarmaRunConfigurationRefactoringHandler", "getRefactoringElementListener"));
        }
        VirtualFile fileAtElement = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (fileAtElement == null) {
            return null;
        }
        KarmaRunSettings settings = configuration.getRunSettings();
        String path = fileAtElement.getPath();
        String configPath = FileUtil.toSystemIndependentName((String)settings.getConfigPath());
        if (configPath.equals(path)) {
            return new FilePathRefactoringElementListener(configuration);
        }
        return null;
    }

    private static class FilePathRefactoringElementListener
    extends UndoRefactoringElementAdapter {
        private final KarmaRunConfiguration myConfiguration;

        private FilePathRefactoringElementListener(@NotNull KarmaRunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/karma/execution/KarmaRunConfigurationRefactoringHandler$FilePathRefactoringElementListener", "<init>"));
            }
            this.myConfiguration = configuration;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/karma/execution/KarmaRunConfigurationRefactoringHandler$FilePathRefactoringElementListener", "refactored"));
            }
            VirtualFile newFile = PsiUtilBase.asVirtualFile((PsiElement)element);
            if (newFile != null) {
                this.myConfiguration.setConfigFilePath(newFile.getPath());
            }
        }
    }
}

