/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.karma.execution.KarmaExecutionSession;
import com.intellij.javascript.karma.execution.KarmaExecutionType;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.execution.KarmaServerSettings;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerRegistry;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.CatchingConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunProfileState
implements RunProfileState {
    private static final Logger LOG = Logger.getInstance(KarmaRunProfileState.class);
    private final Project myProject;
    private final KarmaRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final String myKarmaPackageDirPath;
    private final KarmaRunSettings myRunSettings;
    private final KarmaExecutionType myExecutionType;

    public KarmaRunProfileState(@NotNull Project project, @NotNull KarmaRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull String karmaPackageDirPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "<init>"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "<init>"));
        }
        if (karmaPackageDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaPackageDirPath", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "<init>"));
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myKarmaPackageDirPath = karmaPackageDirPath;
        this.myRunSettings = runConfiguration.getRunSettings();
        this.myExecutionType = KarmaRunProfileState.findExecutionType(this.myEnvironment.getExecutor());
    }

    @Nullable
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "execute"));
        }
        KarmaServer server = this.getServerOrStart(executor);
        if (server != null) {
            return this.executeWithServer(executor, server);
        }
        return null;
    }

    @Nullable
    public KarmaServer getServerOrStart(final @NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "getServerOrStart"));
        }
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolve(this.myProject);
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.castAndValidate((NodeJsInterpreter)interpreter);
        KarmaServerSettings serverSettings = new KarmaServerSettings.Builder().setNodeInterpreter(localInterpreter).setKarmaPackageDirPath(this.myKarmaPackageDirPath).setRunSettings(this.myRunSettings).setWithCoverage(this.myExecutionType == KarmaExecutionType.COVERAGE).build();
        KarmaServerRegistry registry = KarmaServerRegistry.getInstance(this.myProject);
        KarmaServer server = registry.getServer(serverSettings);
        if (server != null && server.getRestarter().isRestartRequired()) {
            server.shutdownAsync();
            server = null;
        }
        if (server == null) {
            registry.startServer(serverSettings, new CatchingConsumer<KarmaServer, Exception>(){

                public void consume(KarmaServer server) {
                    RunnerAndConfigurationSettings configuration = KarmaRunProfileState.this.myEnvironment.getRunnerAndConfigurationSettings();
                    if (configuration != null) {
                        ProgramRunnerUtil.executeConfiguration((Project)KarmaRunProfileState.this.myProject, (RunnerAndConfigurationSettings)configuration, (Executor)executor);
                    }
                }

                public void consume(Exception e) {
                    LOG.error((Throwable)e);
                    KarmaRunProfileState.this.showServerStartupError(e);
                }
            });
        }
        return server;
    }

    @NotNull
    public ExecutionResult executeWithServer(@NotNull Executor executor, @NotNull KarmaServer server) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "executeWithServer"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "executeWithServer"));
        }
        server.getWatcher().flush();
        KarmaExecutionSession session = new KarmaExecutionSession(this.myProject, this.myRunConfiguration, executor, server, this.myRunSettings, this.myExecutionType);
        SMTRunnerConsoleView smtRunnerConsoleView = session.getSmtConsoleView();
        ProcessHandler processHandler = session.getProcessHandler();
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)smtRunnerConsoleView, processHandler);
        executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "executeWithServer"));
        }
        return defaultExecutionResult;
    }

    @NotNull
    private static KarmaExecutionType findExecutionType(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "findExecutionType"));
        }
        if (executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
            KarmaExecutionType karmaExecutionType = KarmaExecutionType.DEBUG;
            if (karmaExecutionType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "findExecutionType"));
            }
            return karmaExecutionType;
        }
        if (executor.equals(ExecutorRegistry.getInstance().getExecutorById("Coverage"))) {
            KarmaExecutionType karmaExecutionType = KarmaExecutionType.COVERAGE;
            if (karmaExecutionType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "findExecutionType"));
            }
            return karmaExecutionType;
        }
        KarmaExecutionType karmaExecutionType = KarmaExecutionType.RUN;
        if (karmaExecutionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "findExecutionType"));
        }
        return karmaExecutionType;
    }

    private void showServerStartupError(@NotNull Exception serverException) {
        if (serverException == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverException", "com/intellij/javascript/karma/execution/KarmaRunProfileState", "showServerStartupError"));
        }
        StringBuilder errorMessage = new StringBuilder("Karma server launching failed");
        String prevMessage = null;
        for (Throwable e = serverException; e != null; e = e.getCause()) {
            String message = e.getMessage();
            if (message == null || message.equals(prevMessage)) continue;
            errorMessage.append("\n\nCaused by:\n");
            errorMessage.append(message);
            prevMessage = message;
        }
        Messages.showErrorDialog((Project)this.myProject, (String)errorMessage.toString(), (String)"Karma Server");
    }
}

