/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RerunTestsAction;
import com.intellij.execution.runners.RerunTestsNotification;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunProgramRunner
extends GenericProgramRunner {
    @NotNull
    public String getRunnerId() {
        if ("KarmaJavaScriptTestRunnerRun" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunProgramRunner", "getRunnerId"));
        }
        return "KarmaJavaScriptTestRunnerRun";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/javascript/karma/execution/KarmaRunProgramRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/javascript/karma/execution/KarmaRunProgramRunner", "canRun"));
        }
        return DefaultRunExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof KarmaRunConfiguration;
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/karma/execution/KarmaRunProgramRunner", "doExecute"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/karma/execution/KarmaRunProgramRunner", "doExecute"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ExecutionResult executionResult = state.execute(environment.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            return null;
        }
        KarmaConsoleView consoleView = KarmaConsoleView.get(executionResult, state);
        RunContentDescriptor descriptor = KarmaUtil.createDefaultDescriptor(executionResult, environment);
        if (consoleView == null) {
            return descriptor;
        }
        KarmaServer server = consoleView.getKarmaExecutionSession().getKarmaServer();
        if (!server.areBrowsersReady()) {
            server.onBrowsersReady(() -> ExecutionUtil.restartIfActive((RunContentDescriptor)descriptor));
        } else {
            RerunTestsNotification.showRerunNotification((RunContentDescriptor)environment.getContentToReuse(), (ExecutionConsole)executionResult.getExecutionConsole());
        }
        RerunTestsAction.register((RunContentDescriptor)descriptor);
        return descriptor;
    }
}

