/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ComparatorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunSettings {
    private final String myConfigPath;
    private final String myKarmaPackageDir;
    private final String myBrowsers;
    private final NodeJsInterpreterRef myInterpreterRef;
    private final EnvironmentVariablesData myEnvData;

    public KarmaRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javascript/karma/execution/KarmaRunSettings", "<init>"));
        }
        this.myConfigPath = FileUtil.toSystemDependentName((String)builder.myConfigPath);
        this.myKarmaPackageDir = builder.myKarmaPackageDir != null ? FileUtil.toSystemDependentName((String)builder.myKarmaPackageDir) : null;
        this.myBrowsers = builder.myBrowsers;
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myEnvData = builder.myEnvData;
    }

    @NotNull
    public String getConfigPath() {
        String string = this.myConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings", "getConfigPath"));
        }
        return string;
    }

    @NotNull
    public String getConfigSystemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myConfigPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings", "getConfigSystemIndependentPath"));
        }
        return string;
    }

    @Nullable
    public String getKarmaPackageDir() {
        return this.myKarmaPackageDir;
    }

    @Nullable
    public String getKarmaPackageDirSystemIndependentPath() {
        return this.myKarmaPackageDir == null ? null : FileUtil.toSystemIndependentName((String)this.myKarmaPackageDir);
    }

    @NotNull
    public String getBrowsers() {
        String string = this.myBrowsers;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings", "getBrowsers"));
        }
        return string;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings", "getEnvData"));
        }
        return environmentVariablesData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KarmaRunSettings that = (KarmaRunSettings)o;
        return this.myConfigPath.equals(that.myConfigPath) && ComparatorUtil.equalsNullable((Object)this.myKarmaPackageDir, (Object)that.myKarmaPackageDir) && this.myBrowsers.equals(that.myBrowsers) && this.myInterpreterRef.getReferenceName().equals(that.myInterpreterRef.getReferenceName()) && this.myEnvData.equals((Object)that.myEnvData);
    }

    public int hashCode() {
        int result = this.myConfigPath.hashCode();
        result = 31 * result + StringUtil.notNullize((String)this.myKarmaPackageDir).hashCode();
        result = 31 * result + this.myBrowsers.hashCode();
        result = 31 * result + this.myInterpreterRef.getReferenceName().hashCode();
        result = 31 * result + this.myEnvData.hashCode();
        return result;
    }

    @NotNull
    public Builder builder() {
        Builder builder = new Builder(this);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings", "builder"));
        }
        return builder;
    }

    public static class Builder {
        private String myConfigPath;
        private String myKarmaPackageDir;
        private String myBrowsers;
        private NodeJsInterpreterRef myInterpreterRef;
        private EnvironmentVariablesData myEnvData;

        public Builder() {
            this.myConfigPath = "";
            this.myKarmaPackageDir = null;
            this.myBrowsers = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
        }

        public Builder(@NotNull KarmaRunSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "<init>"));
            }
            this.myConfigPath = "";
            this.myKarmaPackageDir = null;
            this.myBrowsers = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myConfigPath = settings.getConfigPath();
            this.myKarmaPackageDir = settings.getKarmaPackageDir();
            this.myBrowsers = settings.getBrowsers();
            this.myInterpreterRef = settings.getInterpreterRef();
            this.myEnvData = settings.myEnvData;
        }

        @NotNull
        public Builder setConfigPath(@NotNull String configPath) {
            if (configPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "setConfigPath"));
            }
            this.myConfigPath = configPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "setConfigPath"));
            }
            return builder;
        }

        @NotNull
        public Builder setKarmaPackageDir(@Nullable String karmaPackageDir) {
            this.myKarmaPackageDir = karmaPackageDir;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "setKarmaPackageDir"));
            }
            return builder;
        }

        @NotNull
        public Builder setBrowsers(@NotNull String browsers) {
            if (browsers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browsers", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "setBrowsers"));
            }
            this.myBrowsers = browsers;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "setBrowsers"));
            }
            return builder;
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "setEnvData"));
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "setEnvData"));
            }
            return builder;
        }

        @NotNull
        public KarmaRunSettings build() {
            KarmaRunSettings karmaRunSettings = new KarmaRunSettings(this);
            if (karmaRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder", "build"));
            }
            return karmaRunSettings;
        }
    }
}

