/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunSettingsSerializationUtil {
    private static final String CONFIG_FILE = "config-file";
    private static final String KARMA_PACKAGE_DIR = "karma-package-dir";
    private static final String BROWSERS = "browsers";
    private static final String NODE_INTERPRETER = "node-interpreter";

    private KarmaRunSettingsSerializationUtil() {
    }

    public static KarmaRunSettings readXml(@NotNull Element element) {
        String interpreterRefName;
        String karmaPackageDir;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/karma/execution/KarmaRunSettingsSerializationUtil", "readXml"));
        }
        KarmaRunSettings.Builder builder = new KarmaRunSettings.Builder();
        String configFilePath = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)CONFIG_FILE);
        if (configFilePath == null) {
            configFilePath = KarmaRunSettingsSerializationUtil.getAttrValue(element, CONFIG_FILE);
        }
        builder.setConfigPath(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)configFilePath)));
        String browsers = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)BROWSERS);
        if (browsers == null) {
            browsers = KarmaRunSettingsSerializationUtil.getAttrValue(element, BROWSERS);
        }
        if (browsers != null) {
            builder.setBrowsers(browsers);
        }
        if ((karmaPackageDir = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)KARMA_PACKAGE_DIR)) != null) {
            builder.setKarmaPackageDir(FileUtil.toSystemDependentName((String)karmaPackageDir));
        }
        builder.setInterpreterRef((interpreterRefName = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)NODE_INTERPRETER)) == null ? NodeJsInterpreterRef.createProjectRef() : NodeJsInterpreterRef.create((String)interpreterRefName));
        EnvironmentVariablesData envData = EnvironmentVariablesData.readExternal((Element)element);
        builder.setEnvData(envData);
        return builder.build();
    }

    @Nullable
    private static String getAttrValue(@NotNull Element element, @NotNull String attrKey) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/karma/execution/KarmaRunSettingsSerializationUtil", "getAttrValue"));
        }
        if (attrKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrKey", "com/intellij/javascript/karma/execution/KarmaRunSettingsSerializationUtil", "getAttrValue"));
        }
        Attribute attribute = element.getAttribute(attrKey);
        return attribute != null ? attribute.getValue() : null;
    }

    public static void writeXml(@NotNull Element element, @NotNull KarmaRunSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/karma/execution/KarmaRunSettingsSerializationUtil", "writeXml"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/karma/execution/KarmaRunSettingsSerializationUtil", "writeXml"));
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)CONFIG_FILE, (String)settings.getConfigSystemIndependentPath());
        if (StringUtil.isNotEmpty((String)settings.getBrowsers())) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)BROWSERS, (String)settings.getBrowsers());
        }
        if (settings.getKarmaPackageDirSystemIndependentPath() != null) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)KARMA_PACKAGE_DIR, (String)settings.getKarmaPackageDirSystemIndependentPath());
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)NODE_INTERPRETER, (String)settings.getInterpreterRef().getReferenceName());
        settings.getEnvData().writeExternal(element);
    }
}

