/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class KarmaServerSettings {
    private final NodeJsLocalInterpreter myNodeInterpreter;
    private final String myKarmaPackageDirPath;
    private final KarmaRunSettings myRunSettings;
    private final boolean myWithCoverage;

    private KarmaServerSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javascript/karma/execution/KarmaServerSettings", "<init>"));
        }
        this.myNodeInterpreter = builder.myNodeInterpreter;
        this.myKarmaPackageDirPath = builder.myKarmaPackageDirPath;
        this.myRunSettings = builder.myRunSettings;
        this.myWithCoverage = builder.myWithCoverage;
    }

    @NotNull
    public NodeJsLocalInterpreter getNodeInterpreter() {
        NodeJsLocalInterpreter nodeJsLocalInterpreter = this.myNodeInterpreter;
        if (nodeJsLocalInterpreter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings", "getNodeInterpreter"));
        }
        return nodeJsLocalInterpreter;
    }

    @NotNull
    public File getKarmaPackageDir() {
        File file = new File(this.myKarmaPackageDirPath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings", "getKarmaPackageDir"));
        }
        return file;
    }

    @NotNull
    public KarmaRunSettings getRunSettings() {
        KarmaRunSettings karmaRunSettings = this.myRunSettings;
        if (karmaRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings", "getRunSettings"));
        }
        return karmaRunSettings;
    }

    public boolean isWithCoverage() {
        return this.myWithCoverage;
    }

    @NotNull
    public File getConfigurationFile() {
        File file = new File(this.myRunSettings.getConfigPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings", "getConfigurationFile"));
        }
        return file;
    }

    @NotNull
    public String getConfigurationFilePath() {
        String string = this.myRunSettings.getConfigPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings", "getConfigurationFilePath"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KarmaServerSettings that = (KarmaServerSettings)o;
        return this.myKarmaPackageDirPath.equals(that.myKarmaPackageDirPath) && this.myNodeInterpreter.getInterpreterSystemIndependentPath().equals(that.myNodeInterpreter.getInterpreterSystemIndependentPath()) && this.myRunSettings.equals(that.myRunSettings) && this.myWithCoverage == that.myWithCoverage;
    }

    public int hashCode() {
        int result = this.myNodeInterpreter.getInterpreterSystemIndependentPath().hashCode();
        result = 31 * result + this.myKarmaPackageDirPath.hashCode();
        result = 31 * result + this.myRunSettings.hashCode();
        result = 31 * result + (this.myWithCoverage ? 1 : 0);
        return result;
    }

    public static class Builder {
        private NodeJsLocalInterpreter myNodeInterpreter;
        private String myKarmaPackageDirPath;
        private KarmaRunSettings myRunSettings;
        private boolean myWithCoverage;

        @NotNull
        public Builder setNodeInterpreter(@NotNull NodeJsLocalInterpreter interpreter) {
            if (interpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder", "setNodeInterpreter"));
            }
            this.myNodeInterpreter = interpreter;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder", "setNodeInterpreter"));
            }
            return builder;
        }

        @NotNull
        public Builder setKarmaPackageDirPath(@NotNull String karmaPackageDirPath) {
            if (karmaPackageDirPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaPackageDirPath", "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder", "setKarmaPackageDirPath"));
            }
            this.myKarmaPackageDirPath = karmaPackageDirPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder", "setKarmaPackageDirPath"));
            }
            return builder;
        }

        @NotNull
        public Builder setRunSettings(@NotNull KarmaRunSettings runSettings) {
            if (runSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder", "setRunSettings"));
            }
            this.myRunSettings = runSettings;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder", "setRunSettings"));
            }
            return builder;
        }

        @NotNull
        public Builder setWithCoverage(boolean withCoverage) {
            this.myWithCoverage = withCoverage;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder", "setWithCoverage"));
            }
            return builder;
        }

        @NotNull
        public KarmaServerSettings build() {
            if (this.myNodeInterpreter == null) {
                throw new RuntimeException("Unspecified Node.js interpreter");
            }
            if (this.myKarmaPackageDirPath == null) {
                throw new RuntimeException("Path to karma package isn't set!");
            }
            if (this.myRunSettings == null) {
                throw new RuntimeException("Run settings aren't set!");
            }
            KarmaServerSettings karmaServerSettings = new KarmaServerSettings(this);
            if (karmaServerSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder", "build"));
            }
            return karmaServerSettings;
        }
    }
}

