/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaTestLocationProvider
implements SMTestLocator {
    private static final String PROTOCOL_ID__CONFIG_FILE = "config";
    private static final String PROTOCOL_ID__TEST_SUITE = "suite";
    private static final String PROTOCOL_ID__TEST = "test";
    public static final KarmaTestLocationProvider INSTANCE = new KarmaTestLocationProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "getLocation"));
        }
        Object location = PROTOCOL_ID__CONFIG_FILE.equals(protocol) ? KarmaTestLocationProvider.getConfigLocation(project, path) : (PROTOCOL_ID__TEST_SUITE.equals(protocol) ? KarmaTestLocationProvider.getTestLocation(project, path, true) : (PROTOCOL_ID__TEST.equals(protocol) ? KarmaTestLocationProvider.getTestLocation(project, path, false) : null));
        if (location != null) {
            List<Location> list = Collections.singletonList(location);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "getLocation"));
        }
        return list;
    }

    @Nullable
    private static Location<PsiFile> getConfigLocation(Project project, @NotNull String locationData) {
        PsiFile psiFile;
        if (locationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationData", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "getConfigLocation"));
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(locationData), (boolean)false);
        if (virtualFile != null && virtualFile.isValid() && (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) != null && psiFile.isValid()) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        return null;
    }

    @Nullable
    private static Location getTestLocation(Project project, @NotNull String locationData, boolean isSuite) {
        String testName;
        List<String> suiteNames;
        if (locationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationData", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "getTestLocation"));
        }
        List<String> path = EscapeUtils.split((String)locationData, (char)'.');
        if (path.isEmpty()) {
            return null;
        }
        if (isSuite) {
            suiteNames = path;
            testName = null;
        } else {
            suiteNames = path.subList(0, path.size() - 1);
            testName = path.get(path.size() - 1);
        }
        PsiElement psiElement = KarmaTestLocationProvider.findJasmineElement(project, suiteNames, testName);
        if (psiElement == null) {
            String moduleName = null;
            if (suiteNames.size() == 0) {
                moduleName = "Default Module";
            } else if (suiteNames.size() == 1) {
                moduleName = suiteNames.get(0);
            }
            if (moduleName != null) {
                psiElement = KarmaTestLocationProvider.findQUnitElement(project, moduleName, testName);
            }
        }
        if (psiElement != null) {
            return PsiLocation.fromPsiElement((PsiElement)psiElement);
        }
        return null;
    }

    @Nullable
    private static PsiElement findJasmineElement(Project project, @NotNull List<String> suiteNames, @Nullable String testName) {
        if (suiteNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteNames", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "findJasmineElement"));
        }
        String key = JsTestFileByTestNameIndex.createJasmineKey(suiteNames);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findJsTestFilesByNameInScope((String)key, (GlobalSearchScope)scope);
        JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
        for (VirtualFile file : jsTestVirtualFiles) {
            JasmineFileStructure jasmineFileStructure;
            PsiElement element;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile) || (element = (jasmineFileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile)).findPsiElement(suiteNames, testName)) == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findQUnitElement(Project project, @NotNull String moduleName, @Nullable String testName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/karma/execution/KarmaTestLocationProvider", "findQUnitElement"));
        }
        String key = JsTestFileByTestNameIndex.createQUnitKey((String)moduleName, (String)testName);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findJsTestFilesByNameInScope((String)key, (GlobalSearchScope)scope);
        QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
        for (VirtualFile file : jsTestVirtualFiles) {
            QUnitFileStructure qunitFileStructure;
            PsiElement element;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile) || (element = (qunitFileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile)).findPsiElement(moduleName, testName)) == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }
}

