/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.filter;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaSourceMapStacktraceFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    private static final String SEPARATOR = " <- ";
    private static final String WEBPACK_URL_PREFIX = "webpack:///";
    public static final KarmaSourceMapStacktraceFinder FINDER = new KarmaSourceMapStacktraceFinder();
    private final AbstractFileHyperlinkFilter myBaseFilter;

    public KarmaSourceMapStacktraceFilter(@NotNull Project project, @Nullable String baseDir, @NotNull AbstractFileHyperlinkFilter baseFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter", "<init>"));
        }
        if (baseFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFilter", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter", "<init>"));
        }
        super(project, baseDir);
        this.myBaseFilter = baseFilter;
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        List<FileHyperlinkRawData> list;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter", "parse"));
        }
        if (line.contains(SEPARATOR) && !(list = FINDER.find(line)).isEmpty()) {
            List<FileHyperlinkRawData> list2 = list;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter", "parse"));
            }
            return list2;
        }
        List list3 = this.myBaseFilter.parse(line);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter", "parse"));
        }
        return list3;
    }

    public static class KarmaSourceMapStacktraceFinder
    implements FileHyperlinkRawDataFinder {
        private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("^\\s*at\\s.*\\(([^(]*:\\d+:\\d+) <- .*"), Pattern.compile("^\\s*at\\s+([^\\s(].*:\\d+:\\d+) <- .*"), Pattern.compile("^[^@]*[^/]@(.*:\\d+:\\d+) <- .*"), Pattern.compile("^\\s*([^\\s].*:\\d+:\\d+) <- .*")};
        private static final PatternBasedFileHyperlinkRawDataFinder INNER_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("(.*):(\\d+):(\\d+)"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter$KarmaSourceMapStacktraceFinder", "find"));
            }
            for (Pattern pattern : PATTERNS) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.matches()) continue;
                ArrayList result = ContainerUtil.newArrayList();
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String originalLink = matcher.group(i);
                    String normalizedLink = KarmaSourceMapStacktraceFinder.normalizeLinkPrefix(originalLink);
                    List list = INNER_FINDER.find(normalizedLink);
                    for (FileHyperlinkRawData data : list) {
                        result.add(new FileHyperlinkRawData(data.getFilePath(), data.getDocumentLine(), data.getDocumentColumn(), matcher.start(i), matcher.start(i) + originalLink.length()));
                    }
                }
                ArrayList arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter$KarmaSourceMapStacktraceFinder", "find"));
                }
                return arrayList;
            }
            List<FileHyperlinkRawData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter$KarmaSourceMapStacktraceFinder", "find"));
            }
            return list;
        }

        @NotNull
        private static String normalizeLinkPrefix(@NotNull String link) {
            if (link == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter$KarmaSourceMapStacktraceFinder", "normalizeLinkPrefix"));
            }
            if (link.startsWith(KarmaSourceMapStacktraceFilter.WEBPACK_URL_PREFIX) && (link = link.substring(KarmaSourceMapStacktraceFilter.WEBPACK_URL_PREFIX.length())).startsWith("~/")) {
                link = "node_modules" + link.substring(1);
            }
            String string = link;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/filter/KarmaSourceMapStacktraceFilter$KarmaSourceMapStacktraceFinder", "normalizeLinkPrefix"));
            }
            return string;
        }
    }
}

