/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class KarmaJsSourcesLocator {
    private final File myKarmaPackageDir;
    private final File myKarmaIntellijPackageDir;

    public KarmaJsSourcesLocator(@NotNull File karmaPackageDir) throws IOException {
        if (karmaPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaPackageDir", "com/intellij/javascript/karma/server/KarmaJsSourcesLocator", "<init>"));
        }
        this.myKarmaPackageDir = karmaPackageDir;
        this.myKarmaIntellijPackageDir = KarmaJsSourcesLocator.findKarmaIntellijPackageDir(karmaPackageDir);
    }

    private static File findKarmaIntellijPackageDir(@NotNull File karmaPackageDir) {
        if (karmaPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaPackageDir", "com/intellij/javascript/karma/server/KarmaJsSourcesLocator", "findKarmaIntellijPackageDir"));
        }
        File dir = new File(karmaPackageDir.getParentFile(), "karma-intellij");
        if (dir.isDirectory()) {
            return dir;
        }
        File jsReporterDir = KarmaJsSourcesLocator.getBundledJsReporterDir();
        if (!jsReporterDir.isDirectory()) {
            throw new RuntimeException("Can't find bundled version of karma-intellij node module!");
        }
        return new File(jsReporterDir, "karma-intellij");
    }

    private static File getBundledJsReporterDir() {
        String jarPath = PathUtil.getJarPathForClass(KarmaServer.class);
        if (!jarPath.endsWith(".jar")) {
            return new File(jarPath, "js_reporter");
        }
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            throw new RuntimeException("jar file cannot be null");
        }
        File pluginBaseDir = jarFile.getParentFile().getParentFile();
        return new File(pluginBaseDir, "js_reporter");
    }

    private File getAppFile(@NotNull String baseName) throws IOException {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/javascript/karma/server/KarmaJsSourcesLocator", "getAppFile"));
        }
        File file = new File(this.myKarmaIntellijPackageDir, "lib" + File.separatorChar + baseName);
        if (!file.isFile()) {
            throw new IOException("Can't find " + file);
        }
        return file;
    }

    @NotNull
    public File getServerAppFile() throws IOException {
        File file = this.getAppFile("intellijServer.js");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaJsSourcesLocator", "getServerAppFile"));
        }
        return file;
    }

    @NotNull
    public File getClientAppFile() throws IOException {
        File file = this.getAppFile("intellijRunner.js");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaJsSourcesLocator", "getClientAppFile"));
        }
        return file;
    }

    @NotNull
    public File getKarmaPackageDir() {
        File file = this.myKarmaPackageDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaJsSourcesLocator", "getKarmaPackageDir"));
        }
        return file;
    }
}

