/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.karma.util.ArchivedOutputListener;
import com.intellij.javascript.karma.util.StreamEventListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class KarmaProcessOutputManager {
    private static final int MAX_ARCHIVED_TEXTS_LENGTH = 16384;
    private static final char NEW_LINE = '\n';
    private static final String PREFIX = "##intellij-event[";
    private static final String SUFFIX = "]\n";
    private final ProcessHandler myProcessHandler;
    private final Deque<Pair<String, Key>> myArchivedTexts;
    private int myArchivedTextsLength;
    private boolean myArchiveTextsTruncated;
    private final List<ArchivedOutputListener> myOutputListeners;
    private final List<StreamEventListener> myStdOutStreamEventListeners;
    private final List<Pair<String, Key>> myStdOutCurrentLineChunks;
    private final Consumer<String> myStdOutLineConsumer;

    public KarmaProcessOutputManager(@NotNull ProcessHandler processHandler, @NotNull Consumer<String> stdOutLineConsumer) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "<init>"));
        }
        if (stdOutLineConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdOutLineConsumer", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "<init>"));
        }
        this.myArchivedTexts = new ArrayDeque<Pair<String, Key>>();
        this.myArchivedTextsLength = 0;
        this.myArchiveTextsTruncated = false;
        this.myOutputListeners = new CopyOnWriteArrayList<ArchivedOutputListener>();
        this.myStdOutStreamEventListeners = new CopyOnWriteArrayList<StreamEventListener>();
        this.myStdOutCurrentLineChunks = ContainerUtil.newArrayList();
        this.myProcessHandler = processHandler;
        this.myStdOutLineConsumer = stdOutLineConsumer;
    }

    public void startNotify() {
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                if (outputType != ProcessOutputTypes.SYSTEM && outputType != ProcessOutputTypes.STDERR) {
                    KarmaProcessOutputManager.this.processStandardOutput(text, outputType);
                } else {
                    KarmaProcessOutputManager.this.addText(text, outputType);
                }
            }
        });
        this.myProcessHandler.startNotify();
    }

    private void processStandardOutput(@NotNull String text, @NotNull Key type) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "processStandardOutput"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "processStandardOutput"));
        }
        int lineStartInd = 0;
        int newLineInd = text.indexOf(10, lineStartInd);
        while (newLineInd != -1) {
            String line = text.substring(lineStartInd, newLineInd + 1);
            if (!this.myStdOutCurrentLineChunks.isEmpty()) {
                this.myStdOutCurrentLineChunks.add((Pair<String, Key>)Pair.create((Object)line, (Object)type));
                line = this.concatCurrentLineChunks();
            }
            if (!this.handleLineAsEvent(line)) {
                this.onStandardOutputLineAvailable(line);
                if (!this.myStdOutCurrentLineChunks.isEmpty()) {
                    for (Pair<String, Key> chunk : this.myStdOutCurrentLineChunks) {
                        this.addText((String)chunk.getFirst(), (Key)chunk.getSecond());
                    }
                } else {
                    this.addText(line, type);
                }
            }
            this.myStdOutCurrentLineChunks.clear();
            lineStartInd = newLineInd + 1;
            newLineInd = text.indexOf(10, lineStartInd);
        }
        if (lineStartInd < text.length()) {
            this.myStdOutCurrentLineChunks.add((Pair<String, Key>)Pair.create((Object)text.substring(lineStartInd), (Object)type));
        }
    }

    @NotNull
    private String concatCurrentLineChunks() {
        int size = 0;
        for (Pair<String, Key> chunk : this.myStdOutCurrentLineChunks) {
            size += ((String)chunk.getFirst()).length();
        }
        StringBuilder result = new StringBuilder(size);
        for (Pair<String, Key> chunk : this.myStdOutCurrentLineChunks) {
            result.append((String)chunk.getFirst());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "concatCurrentLineChunks"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addText(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "addText"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "addText"));
        }
        Deque<Pair<String, Key>> deque = this.myArchivedTexts;
        synchronized (deque) {
            this.myArchivedTexts.addLast((Pair<String, Key>)Pair.create((Object)text, (Object)outputType));
            this.myArchivedTextsLength += text.length();
            while (this.myArchivedTextsLength > 16384) {
                Pair<String, Key> pair = this.myArchivedTexts.removeFirst();
                this.myArchivedTextsLength -= ((String)pair.getFirst()).length();
                this.myArchiveTextsTruncated = true;
            }
            for (ArchivedOutputListener listener : this.myOutputListeners) {
                listener.onOutputAvailable(text, outputType, false);
            }
        }
    }

    private void onStandardOutputLineAvailable(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "onStandardOutputLineAvailable"));
        }
        this.myStdOutLineConsumer.consume((Object)line);
    }

    private boolean handleLineAsEvent(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "handleLineAsEvent"));
        }
        if (line.startsWith(PREFIX) && line.endsWith(SUFFIX)) {
            int colonInd = line.indexOf(58);
            if (colonInd == -1) {
                return false;
            }
            String eventType = line.substring(PREFIX.length(), colonInd);
            String eventBody = line.substring(colonInd + 1, line.length() - SUFFIX.length());
            for (StreamEventListener listener : this.myStdOutStreamEventListeners) {
                listener.on(eventType, eventBody);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "getProcessHandler"));
        }
        return processHandler;
    }

    public void addOutputListener(@NotNull ArchivedOutputListener outputListener) {
        if (outputListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputListener", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "addOutputListener"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (outputListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputListener", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "lambda$addOutputListener$0"));
            }
            Deque<Pair<String, Key>> deque = this.myArchivedTexts;
            synchronized (deque) {
                if (this.myArchiveTextsTruncated) {
                    outputListener.onOutputAvailable("... too much output to process, truncated\n", ProcessOutputTypes.SYSTEM, true);
                }
                for (Pair<String, Key> text : this.myArchivedTexts) {
                    outputListener.onOutputAvailable((String)text.getFirst(), (Key)text.getSecond(), true);
                }
                this.myOutputListeners.add(outputListener);
            }
        });
    }

    public void removeOutputListener(@NotNull ArchivedOutputListener outputListener) {
        if (outputListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputListener", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "removeOutputListener"));
        }
        this.myOutputListeners.remove(outputListener);
    }

    void addStreamEventListener(@NotNull StreamEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javascript/karma/server/KarmaProcessOutputManager", "addStreamEventListener"));
        }
        this.myStdOutStreamEventListeners.add(listener);
    }
}

