/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.coverage.KarmaCoveragePeer;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.execution.KarmaServerSettings;
import com.intellij.javascript.karma.server.CapturedBrowser;
import com.intellij.javascript.karma.server.KarmaJsSourcesLocator;
import com.intellij.javascript.karma.server.KarmaProcessOutputManager;
import com.intellij.javascript.karma.server.KarmaServerRestarter;
import com.intellij.javascript.karma.server.KarmaServerState;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.javascript.karma.server.StreamEventHandler;
import com.intellij.javascript.karma.server.watch.KarmaWatcher;
import com.intellij.javascript.karma.util.StreamEventListener;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaServer {
    private static final Logger LOG = Logger.getInstance(KarmaServer.class);
    private final KarmaProcessOutputManager myProcessOutputManager;
    private final KarmaJsSourcesLocator myKarmaJsSourcesLocator;
    private final KarmaServerState myState;
    private final KarmaCoveragePeer myCoveragePeer;
    private final KarmaWatcher myWatcher;
    private final KarmaServerSettings myServerSettings;
    private List<Runnable> myOnPortBoundCallbacks;
    private List<Runnable> myOnBrowsersReadyCallbacks;
    private Integer myExitCode;
    private final List<KarmaServerTerminatedListener> myTerminationCallbacks;
    private final Map<String, StreamEventHandler> myHandlers;
    private final MyDisposable myDisposable;
    private final KarmaServerRestarter myRestarter;
    private final int myProcessHashCode;

    public KarmaServer(@NotNull Project project, @NotNull KarmaServerSettings serverSettings) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/server/KarmaServer", "<init>"));
        }
        if (serverSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSettings", "com/intellij/javascript/karma/server/KarmaServer", "<init>"));
        }
        this.myOnPortBoundCallbacks = Lists.newCopyOnWriteArrayList();
        this.myOnBrowsersReadyCallbacks = Lists.newCopyOnWriteArrayList();
        this.myExitCode = null;
        this.myTerminationCallbacks = Lists.newCopyOnWriteArrayList();
        this.myHandlers = ContainerUtil.newConcurrentMap();
        this.myServerSettings = serverSettings;
        this.myKarmaJsSourcesLocator = new KarmaJsSourcesLocator(serverSettings.getKarmaPackageDir());
        this.myCoveragePeer = serverSettings.isWithCoverage() ? new KarmaCoveragePeer() : null;
        KillableColoredProcessHandler processHandler = this.startServer(serverSettings);
        this.myProcessHashCode = System.identityHashCode(processHandler.getProcess());
        File configurationFile = this.myServerSettings.getConfigurationFile();
        this.myState = new KarmaServerState(this, configurationFile);
        this.myProcessOutputManager = new KarmaProcessOutputManager((ProcessHandler)processHandler, (Consumer<String>)((Consumer)this.myState::onStandardOutputLineAvailable));
        this.myWatcher = new KarmaWatcher(this);
        this.registerStreamEventHandlers();
        this.myProcessOutputManager.startNotify();
        this.myDisposable = new MyDisposable();
        Disposer.register((Disposable)project, (Disposable)this.myDisposable);
        this.myRestarter = new KarmaServerRestarter(configurationFile, this.myDisposable);
    }

    private void registerStreamEventHandlers() {
        if (this.myCoveragePeer != null) {
            this.myCoveragePeer.registerEventHandlers(this);
        }
        this.registerStreamEventHandler(this.myWatcher.getEventHandler());
        this.myProcessOutputManager.addStreamEventListener(new StreamEventListener(){

            @Override
            public void on(@NotNull String eventType, @NotNull String eventBody) {
                JsonElement jsonElement;
                if (eventType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/intellij/javascript/karma/server/KarmaServer$1", "on"));
                }
                if (eventBody == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventBody", "com/intellij/javascript/karma/server/KarmaServer$1", "on"));
                }
                LOG.info("Processing Karma event " + eventType + " " + eventBody);
                try {
                    JsonParser jsonParser = new JsonParser();
                    jsonElement = jsonParser.parse(eventBody);
                }
                catch (Exception e) {
                    LOG.warn("Cannot parse message from karma server: (eventType: " + eventType + ", eventBody: " + eventBody + ")");
                    return;
                }
                StreamEventHandler handler = (StreamEventHandler)KarmaServer.this.myHandlers.get(eventType);
                if (handler != null) {
                    handler.handle(jsonElement);
                } else {
                    LOG.warn("Cannot find handler for " + eventType);
                }
            }
        });
    }

    @NotNull
    public KarmaServerSettings getServerSettings() {
        KarmaServerSettings karmaServerSettings = this.myServerSettings;
        if (karmaServerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "getServerSettings"));
        }
        return karmaServerSettings;
    }

    @NotNull
    public NodeJsLocalInterpreter getNodeInterpreter() {
        NodeJsLocalInterpreter nodeJsLocalInterpreter = this.myServerSettings.getNodeInterpreter();
        if (nodeJsLocalInterpreter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "getNodeInterpreter"));
        }
        return nodeJsLocalInterpreter;
    }

    @NotNull
    public KarmaServerRestarter getRestarter() {
        KarmaServerRestarter karmaServerRestarter = this.myRestarter;
        if (karmaServerRestarter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "getRestarter"));
        }
        return karmaServerRestarter;
    }

    @NotNull
    public File getKarmaPackageDir() {
        File file = this.myServerSettings.getKarmaPackageDir();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "getKarmaPackageDir"));
        }
        return file;
    }

    @Nullable
    public KarmaCoveragePeer getCoveragePeer() {
        return this.myCoveragePeer;
    }

    @NotNull
    public KarmaWatcher getWatcher() {
        KarmaWatcher karmaWatcher = this.myWatcher;
        if (karmaWatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "getWatcher"));
        }
        return karmaWatcher;
    }

    @NotNull
    public KarmaJsSourcesLocator getKarmaJsSourcesLocator() {
        KarmaJsSourcesLocator karmaJsSourcesLocator = this.myKarmaJsSourcesLocator;
        if (karmaJsSourcesLocator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "getKarmaJsSourcesLocator"));
        }
        return karmaJsSourcesLocator;
    }

    public void registerStreamEventHandler(@NotNull StreamEventHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/javascript/karma/server/KarmaServer", "registerStreamEventHandler"));
        }
        this.myHandlers.put(handler.getEventType(), handler);
    }

    private KillableColoredProcessHandler startServer(@NotNull KarmaServerSettings serverSettings) throws IOException {
        KillableColoredProcessHandler processHandler;
        if (serverSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSettings", "com/intellij/javascript/karma/server/KarmaServer", "startServer"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        KarmaRunSettings runSettings = serverSettings.getRunSettings();
        runSettings.getEnvData().configureCommandLine(commandLine, true);
        commandLine.withWorkDirectory(serverSettings.getConfigurationFile().getParentFile());
        commandLine.setExePath(serverSettings.getNodeInterpreter().getInterpreterSystemDependentPath());
        File serverFile = this.myKarmaJsSourcesLocator.getServerAppFile();
        commandLine.addParameter(serverFile.getAbsolutePath());
        commandLine.addParameter("--karmaPackageDir=" + this.myKarmaJsSourcesLocator.getKarmaPackageDir().getAbsolutePath());
        commandLine.addParameter("--configFile=" + serverSettings.getConfigurationFilePath());
        String browsers = serverSettings.getRunSettings().getBrowsers();
        if (!StringUtil.isEmptyOrSpaces((String)browsers)) {
            commandLine.addParameter("--browsers=" + browsers);
        }
        if (this.myCoveragePeer != null) {
            commandLine.addParameter("--coverageTempDir=" + this.myCoveragePeer.getCoverageTempDir());
        }
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        try {
            processHandler = new KillableColoredProcessHandler(commandLine);
        }
        catch (ExecutionException e) {
            throw new IOException("Can not start Karma server: " + commandLine.getCommandLineString(), e);
        }
        final int processHashCode = System.identityHashCode(processHandler.getProcess());
        LOG.info("Karma server " + processHashCode + " started successfully: " + commandLine.getCommandLineString());
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                LOG.info("Karma server " + processHashCode + " terminated with exit code " + event.getExitCode());
                Disposer.dispose((Disposable)KarmaServer.this.myDisposable);
                KarmaServer.this.fireOnTerminated(event.getExitCode());
            }
        });
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        processHandler.setShouldDestroyProcessRecursively(true);
        return processHandler;
    }

    public void shutdownAsync() {
        LOG.info("Shutting down asynchronously Karma server " + this.myProcessHashCode);
        ApplicationManager.getApplication().executeOnPooledThread(this::shutdown);
    }

    private void shutdown() {
        ProcessHandler processHandler = this.myProcessOutputManager.getProcessHandler();
        if (!processHandler.isProcessTerminated()) {
            ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)1000L, null);
        }
    }

    @NotNull
    public KarmaProcessOutputManager getProcessOutputManager() {
        KarmaProcessOutputManager karmaProcessOutputManager = this.myProcessOutputManager;
        if (karmaProcessOutputManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "getProcessOutputManager"));
        }
        return karmaProcessOutputManager;
    }

    public boolean isPortBound() {
        return this.myState.getServerPort() != -1;
    }

    public int getServerPort() {
        return this.myState.getServerPort();
    }

    public void onPortBound(@NotNull Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javascript/karma/server/KarmaServer", "onPortBound"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javascript/karma/server/KarmaServer", "lambda$onPortBound$0"));
            }
            if (this.myOnPortBoundCallbacks != null) {
                this.myOnPortBoundCallbacks.add(callback);
            } else {
                callback.run();
            }
        });
    }

    void fireOnPortBound() {
        UIUtil.invokeLaterIfNeeded(() -> {
            ArrayList callbacks = ContainerUtil.newArrayList(this.myOnPortBoundCallbacks);
            this.myOnPortBoundCallbacks.clear();
            this.myOnPortBoundCallbacks = null;
            for (Runnable callback : callbacks) {
                callback.run();
            }
        });
    }

    public boolean areBrowsersReady() {
        return this.myState.areBrowsersReady();
    }

    @NotNull
    public Collection<CapturedBrowser> getCapturedBrowsers() {
        Collection<CapturedBrowser> collection = this.myState.getCapturedBrowsers();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "getCapturedBrowsers"));
        }
        return collection;
    }

    public void onBrowsersReady(@NotNull Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javascript/karma/server/KarmaServer", "onBrowsersReady"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javascript/karma/server/KarmaServer", "lambda$onBrowsersReady$2"));
            }
            if (this.myOnBrowsersReadyCallbacks != null) {
                this.myOnBrowsersReadyCallbacks.add(callback);
            } else {
                callback.run();
            }
        });
    }

    void fireOnBrowsersReady() {
        UIUtil.invokeLaterIfNeeded(() -> {
            ArrayList callbacks = ContainerUtil.newArrayList(this.myOnBrowsersReadyCallbacks);
            this.myOnBrowsersReadyCallbacks.clear();
            this.myOnBrowsersReadyCallbacks = null;
            for (Runnable callback : callbacks) {
                callback.run();
            }
        });
    }

    public void onTerminated(@NotNull KarmaServerTerminatedListener terminationCallback) {
        if (terminationCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminationCallback", "com/intellij/javascript/karma/server/KarmaServer", "onTerminated"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (terminationCallback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminationCallback", "com/intellij/javascript/karma/server/KarmaServer", "lambda$onTerminated$4"));
            }
            if (this.myExitCode != null) {
                terminationCallback.onTerminated(this.myExitCode);
            } else {
                this.myTerminationCallbacks.add(terminationCallback);
            }
        });
    }

    public void removeTerminatedListener(@NotNull KarmaServerTerminatedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javascript/karma/server/KarmaServer", "removeTerminatedListener"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javascript/karma/server/KarmaServer", "lambda$removeTerminatedListener$5"));
            }
            this.myTerminationCallbacks.remove(listener);
        });
    }

    private void fireOnTerminated(int exitCode) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myExitCode = exitCode;
            ArrayList listeners = ContainerUtil.newArrayList(this.myTerminationCallbacks);
            this.myTerminationCallbacks.clear();
            for (KarmaServerTerminatedListener listener : listeners) {
                listener.onTerminated(exitCode);
            }
        });
    }

    @Nullable
    public KarmaConfig getKarmaConfig() {
        return this.myState.getKarmaConfig();
    }

    @NotNull
    public String formatUrlWithoutUrlRoot(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/karma/server/KarmaServer", "formatUrlWithoutUrlRoot"));
        }
        String string = this.formatUrl(path, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "formatUrlWithoutUrlRoot"));
        }
        return string;
    }

    @NotNull
    public String formatUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/karma/server/KarmaServer", "formatUrl"));
        }
        String string = this.formatUrl(path, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "formatUrl"));
        }
        return string;
    }

    @NotNull
    private String formatUrl(@NotNull String path, boolean withUrlRoot) {
        KarmaConfig config;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/karma/server/KarmaServer", "formatUrl"));
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((config = this.myState.getKarmaConfig()) != null) {
            String baseUrl = "http://" + config.getHostname() + ":" + this.getServerPort();
            String urlRoot = config.getUrlRoot();
            if (!withUrlRoot || "/".equals(urlRoot)) {
                String string = baseUrl + path;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "formatUrl"));
                }
                return string;
            }
            String string = baseUrl + config.getUrlRoot() + path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "formatUrl"));
            }
            return string;
        }
        LOG.error("Karma config isn't ready yet.");
        String string = "http://localhost:" + this.getServerPort() + path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "formatUrl"));
        }
        return string;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessOutputManager.getProcessHandler();
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServer", "getProcessHandler"));
        }
        return processHandler;
    }

    private class MyDisposable
    implements Disposable {
        private volatile boolean myDisposed = false;

        private MyDisposable() {
        }

        public void dispose() {
            if (this.myDisposed) {
                return;
            }
            LOG.info("Disposing Karma server " + KarmaServer.this.myProcessHashCode);
            KarmaServer.this.myWatcher.stop();
            if (KarmaServer.this.myCoveragePeer != null) {
                KarmaServer.this.myCoveragePeer.dispose();
                FileUtil.asyncDelete((File)KarmaServer.this.myCoveragePeer.getCoverageTempDir());
            }
            if (KarmaServer.this.myOnPortBoundCallbacks != null) {
                KarmaServer.this.myOnPortBoundCallbacks.clear();
            }
            if (KarmaServer.this.myOnBrowsersReadyCallbacks != null) {
                KarmaServer.this.myOnBrowsersReadyCallbacks.clear();
            }
            KarmaServer.this.shutdown();
        }
    }
}

