/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.javascript.karma.util.ArchivedOutputListener;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaServerLogComponent
implements ComponentWithActions {
    private final ConsoleView myConsole;
    private final KarmaServer myServer;
    private ActionGroup myActionGroup;

    private KarmaServerLogComponent(@NotNull ConsoleView console, @NotNull KarmaServer server) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/javascript/karma/server/KarmaServerLogComponent", "<init>"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/server/KarmaServerLogComponent", "<init>"));
        }
        this.myConsole = console;
        this.myServer = server;
    }

    @Nullable
    public ActionGroup getToolbarActions() {
        AnAction[] actions;
        if (this.myActionGroup != null) {
            return this.myActionGroup;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new StopProcessAction("Stop Karma Server", null, this.myServer.getProcessHandler()));
        for (AnAction action : actions = this.myConsole.createConsoleActions()) {
            group.add(action);
        }
        group.addSeparator();
        this.myActionGroup = group;
        return this.myActionGroup;
    }

    @Nullable
    public JComponent getSearchComponent() {
        return null;
    }

    @Nullable
    public String getToolbarPlace() {
        return "unknown";
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        return this.myConsole.getComponent();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myConsole.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServerLogComponent", "getComponent"));
        }
        return jComponent;
    }

    public boolean isContentBuiltIn() {
        return false;
    }

    @NotNull
    private static ConsoleView createConsole(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/server/KarmaServerLogComponent", "createConsole"));
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(project, scope);
        builder.setUsePredefinedMessageFilter(false);
        builder.addFilter((Filter)new NodeStackTraceFilter(project));
        ConsoleView consoleView = builder.getConsole();
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServerLogComponent", "createConsole"));
        }
        return consoleView;
    }

    public static void register(@NotNull Project project, final @NotNull KarmaServer server, final @NotNull RunnerLayoutUi ui, boolean requestFocus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/server/KarmaServerLogComponent", "register"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/server/KarmaServerLogComponent", "register"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/javascript/karma/server/KarmaServerLogComponent", "register"));
        }
        final ConsoleView console = KarmaServerLogComponent.createConsole(project);
        KarmaServerLogComponent component = new KarmaServerLogComponent(console, server);
        final Content content = ui.createContent("KarmaServer", (ComponentWithActions)component, "Karma Server", null, console.getPreferredFocusableComponent());
        content.setCloseable(false);
        ui.addContent(content, 4, PlaceInGrid.bottom, false);
        if (requestFocus && !server.isPortBound()) {
            ui.selectAndFocus(content, false, false);
        }
        final KarmaServerTerminatedListener terminationCallback = new KarmaServerTerminatedListener(){

            @Override
            public void onTerminated(int exitCode) {
                KarmaUtil.selectAndFocusIfNotDisposed(ui, content, false, false);
            }
        };
        server.onTerminated(terminationCallback);
        final ArchivedOutputListener outputListener = new ArchivedOutputListener(){

            @Override
            public void onOutputAvailable(@NotNull String text, Key outputType, boolean archived) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/karma/server/KarmaServerLogComponent$2", "onOutputAvailable"));
                }
                ConsoleViewContentType contentType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                console.print(text, contentType);
                if (!archived && text.startsWith("ERROR ")) {
                    ApplicationManager.getApplication().invokeLater(() -> content.fireAlert(), ModalityState.any());
                }
            }
        };
        server.getProcessOutputManager().addOutputListener(outputListener);
        Disposer.register((Disposable)content, (Disposable)console);
        Disposer.register((Disposable)console, (Disposable)new Disposable(){

            public void dispose() {
                server.removeTerminatedListener(terminationCallback);
                server.getProcessOutputManager().removeOutputListener(outputListener);
            }
        });
    }
}

