/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.concurrency.JobScheduler;
import com.intellij.javascript.karma.execution.KarmaServerSettings;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.CatchingConsumer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaServerRegistry {
    private static final Logger LOG = Logger.getInstance(KarmaServerRegistry.class);
    private final Project myProject;
    private final ConcurrentMap<String, KarmaServer> myServerByConfigFile;
    private final ConcurrentMap<KarmaServerSettings, KarmaServer> myServers;
    private final ConcurrentMap<KarmaServerSettings, KarmaServerSettings> myStartingServers;

    public KarmaServerRegistry(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/server/KarmaServerRegistry", "<init>"));
        }
        this.myServerByConfigFile = new ConcurrentHashMap<String, KarmaServer>();
        this.myServers = new ConcurrentHashMap<KarmaServerSettings, KarmaServer>();
        this.myStartingServers = new ConcurrentHashMap<KarmaServerSettings, KarmaServerSettings>();
        this.myProject = project;
    }

    @NotNull
    public static KarmaServerRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/server/KarmaServerRegistry", "getInstance"));
        }
        KarmaServerRegistry karmaServerRegistry = (KarmaServerRegistry)ServiceManager.getService((Project)project, KarmaServerRegistry.class);
        if (karmaServerRegistry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServerRegistry", "getInstance"));
        }
        return karmaServerRegistry;
    }

    @Nullable
    public KarmaServer getServer(@NotNull KarmaServerSettings serverSettings) {
        if (serverSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSettings", "com/intellij/javascript/karma/server/KarmaServerRegistry", "getServer"));
        }
        return (KarmaServer)this.myServers.get(serverSettings);
    }

    public void startServer(final @NotNull KarmaServerSettings serverSettings, final CatchingConsumer<KarmaServer, Exception> consumer) {
        if (serverSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSettings", "com/intellij/javascript/karma/server/KarmaServerRegistry", "startServer"));
        }
        KarmaServer prevServer = (KarmaServer)this.myServerByConfigFile.get(serverSettings.getConfigurationFilePath());
        if (prevServer != null) {
            prevServer.onTerminated(new KarmaServerTerminatedListener(){

                @Override
                public void onTerminated(int exitCode) {
                    KarmaServerRegistry.this.doStartServer(serverSettings, (CatchingConsumer<KarmaServer, Exception>)consumer);
                }
            });
            prevServer.shutdownAsync();
        } else {
            this.doStartServer(serverSettings, consumer);
        }
    }

    private void doStartServer(final @NotNull KarmaServerSettings serverSettings, @NotNull CatchingConsumer<KarmaServer, Exception> consumer) {
        if (serverSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSettings", "com/intellij/javascript/karma/server/KarmaServerRegistry", "doStartServer"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/karma/server/KarmaServerRegistry", "doStartServer"));
        }
        if (this.myStartingServers.putIfAbsent(serverSettings, serverSettings) != null) {
            LOG.warn(new Throwable("Unexpected subsequent karma server starting:" + serverSettings.toString()));
            JobScheduler.getScheduler().schedule(() -> {
                if (serverSettings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSettings", "com/intellij/javascript/karma/server/KarmaServerRegistry", "lambda$doStartServer$0"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/karma/server/KarmaServerRegistry", "lambda$doStartServer$0"));
                }
                this.startServer(serverSettings, consumer);
            }, 100L, TimeUnit.MILLISECONDS);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (serverSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSettings", "com/intellij/javascript/karma/server/KarmaServerRegistry", "lambda$doStartServer$3"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/karma/server/KarmaServerRegistry", "lambda$doStartServer$3"));
            }
            try {
                KarmaServer server;
                try {
                    server = new KarmaServer(this.myProject, serverSettings);
                    this.myServers.put(serverSettings, server);
                    this.myServerByConfigFile.put(serverSettings.getConfigurationFilePath(), server);
                }
                finally {
                    this.myStartingServers.remove(serverSettings);
                }
                server.onTerminated(new KarmaServerTerminatedListener(){

                    @Override
                    public void onTerminated(int exitCode) {
                        KarmaServerRegistry.this.myServers.remove(serverSettings, server);
                        KarmaServerRegistry.this.myServerByConfigFile.remove(serverSettings.getConfigurationFilePath(), server);
                    }
                });
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/karma/server/KarmaServerRegistry", "lambda$null$1"));
                    }
                    consumer.consume((Object)server);
                });
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/karma/server/KarmaServerRegistry", "lambda$null$2"));
                    }
                    consumer.consume((Throwable)e);
                });
            }
        });
    }
}

