/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class KarmaServerRestarter {
    private final AtomicInteger myActiveRunners;
    private final AtomicBoolean myConfigChanged;
    private boolean myRestartRequested;

    public KarmaServerRestarter(@NotNull File configurationFile, @NotNull Disposable parentDisposable) {
        if (configurationFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFile", "com/intellij/javascript/karma/server/KarmaServerRestarter", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/javascript/karma/server/KarmaServerRestarter", "<init>"));
        }
        this.myActiveRunners = new AtomicInteger(0);
        this.myConfigChanged = new AtomicBoolean(false);
        this.myRestartRequested = false;
        this.listenForConfigurationFileChanges(configurationFile, parentDisposable);
    }

    private void listenForConfigurationFileChanges(@NotNull File configurationFile, @NotNull Disposable parentDisposable) {
        if (configurationFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFile", "com/intellij/javascript/karma/server/KarmaServerRestarter", "listenForConfigurationFileChanges"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/javascript/karma/server/KarmaServerRestarter", "listenForConfigurationFileChanges"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (configurationFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFile", "com/intellij/javascript/karma/server/KarmaServerRestarter", "lambda$listenForConfigurationFileChanges$1"));
            }
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/javascript/karma/server/KarmaServerRestarter", "lambda$listenForConfigurationFileChanges$1"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                Document document;
                if (configurationFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFile", "com/intellij/javascript/karma/server/KarmaServerRestarter", "lambda$null$0"));
                }
                if (parentDisposable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/javascript/karma/server/KarmaServerRestarter", "lambda$null$0"));
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(configurationFile);
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory() && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null && !Disposer.isDisposed((Disposable)parentDisposable)) {
                    document.addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void documentChanged(DocumentEvent e) {
                            KarmaServerRestarter.this.myConfigChanged.set(true);
                        }
                    }, parentDisposable);
                }
            });
        }, ModalityState.any());
    }

    public void onRunnerExecutionStarted(final @NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/javascript/karma/server/KarmaServerRestarter", "onRunnerExecutionStarted"));
        }
        this.myActiveRunners.incrementAndGet();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                KarmaServerRestarter.this.myActiveRunners.decrementAndGet();
                processHandler.removeProcessListener((ProcessListener)this);
            }
        });
    }

    public boolean isRestartRequired() {
        return this.myActiveRunners.get() == 0 && (this.myRestartRequested || this.myConfigChanged.get());
    }

    public void requestRestart() {
        this.myRestartRequested = true;
    }
}

