/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.server.CapturedBrowser;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.StreamEventHandler;
import com.intellij.javascript.karma.util.GsonUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaServerState {
    private static final Logger LOG = Logger.getInstance(KarmaServerState.class);
    private static final String BROWSER_CONNECTED_EVENT_TYPE = "browserConnected";
    private static final String BROWSER_DISCONNECTED_EVENT_TYPE = "browserDisconnected";
    private static final Pattern SERVER_PORT_LINE_PATTERN = Pattern.compile("Karma.+server started at http://[^:]+:(\\d+)/.*$");
    private static final String[][] FAILED_TO_START_BROWSER_PATTERNS = new String[][]{{"ERROR [launcher]: No binary for ", " browser on your platform.\n"}, {"WARN [launcher]: Can not load \"", "\", it is not registered!\n"}, {"ERROR [launcher]: Cannot start ", "\n"}};
    private final KarmaServer myServer;
    private final List<String> myOverriddenBrowsers;
    private final ConcurrentMap<String, CapturedBrowser> myCapturedBrowsers;
    private final AtomicInteger myBoundServerPort;
    private final AtomicBoolean myBrowsersReady;
    private final List<String> myFailedToStartBrowsers;
    private volatile KarmaConfig myConfig;

    public KarmaServerState(@NotNull KarmaServer server, @NotNull File configurationFile) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/server/KarmaServerState", "<init>"));
        }
        if (configurationFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFile", "com/intellij/javascript/karma/server/KarmaServerState", "<init>"));
        }
        this.myCapturedBrowsers = Maps.newConcurrentMap();
        this.myBoundServerPort = new AtomicInteger(-1);
        this.myBrowsersReady = new AtomicBoolean(false);
        this.myFailedToStartBrowsers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myServer = server;
        this.myOverriddenBrowsers = KarmaServerState.parseBrowsers(server.getServerSettings().getRunSettings().getBrowsers());
        this.myServer.registerStreamEventHandler(new BrowserEventHandler(BROWSER_CONNECTED_EVENT_TYPE));
        this.myServer.registerStreamEventHandler(new BrowserEventHandler(BROWSER_DISCONNECTED_EVENT_TYPE));
        this.myServer.registerStreamEventHandler(new ConfigHandler(configurationFile));
    }

    @Nullable
    private static List<String> parseBrowsers(@NotNull String browsersStr) {
        if (browsersStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browsersStr", "com/intellij/javascript/karma/server/KarmaServerState", "parseBrowsers"));
        }
        if (StringUtil.isEmptyOrSpaces((String)browsersStr)) {
            return null;
        }
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return splitter.splitToList((CharSequence)browsersStr);
    }

    private void handleBrowsersChange(@NotNull String eventType, @NotNull String browserId, @NotNull String browserName, @Nullable Boolean autoCaptured) {
        if (eventType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/intellij/javascript/karma/server/KarmaServerState", "handleBrowsersChange"));
        }
        if (browserId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserId", "com/intellij/javascript/karma/server/KarmaServerState", "handleBrowsersChange"));
        }
        if (browserName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserName", "com/intellij/javascript/karma/server/KarmaServerState", "handleBrowsersChange"));
        }
        if (BROWSER_CONNECTED_EVENT_TYPE.equals(eventType)) {
            boolean captured = (Boolean)ObjectUtils.notNull((Object)autoCaptured, (Object)true);
            CapturedBrowser browser = new CapturedBrowser(browserName, browserId, captured);
            this.myCapturedBrowsers.put(browserId, browser);
            if (autoCaptured == Boolean.FALSE || this.canSetBrowsersReady()) {
                this.setBrowsersReady();
            }
        } else {
            this.myCapturedBrowsers.remove(browserId);
        }
    }

    private boolean canSetBrowsersReady() {
        List<String> expectedBrowsers = this.myOverriddenBrowsers;
        if (expectedBrowsers == null) {
            KarmaConfig config = this.myConfig;
            if (config == null) {
                return true;
            }
            expectedBrowsers = config.getBrowsers();
        }
        HashSet expectedBrowserSet = ContainerUtil.newHashSet(expectedBrowsers);
        expectedBrowserSet.removeAll(this.myFailedToStartBrowsers);
        int autoCapturedBrowserCount = this.getAutoCapturedBrowserCount();
        return autoCapturedBrowserCount > 0 && expectedBrowserSet.size() <= autoCapturedBrowserCount;
    }

    private int getAutoCapturedBrowserCount() {
        int res = 0;
        for (CapturedBrowser browser : this.myCapturedBrowsers.values()) {
            if (!browser.isAutoCaptured()) continue;
            ++res;
        }
        return res;
    }

    private void setBrowsersReady() {
        if (this.myBrowsersReady.compareAndSet(false, true)) {
            this.myServer.fireOnBrowsersReady();
        }
    }

    public boolean areBrowsersReady() {
        return this.myBrowsersReady.get();
    }

    @NotNull
    public Collection<CapturedBrowser> getCapturedBrowsers() {
        Collection<CapturedBrowser> collection = this.myCapturedBrowsers.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServerState", "getCapturedBrowsers"));
        }
        return collection;
    }

    public int getServerPort() {
        return this.myBoundServerPort.get();
    }

    @Nullable
    public KarmaConfig getKarmaConfig() {
        return this.myConfig;
    }

    public void onStandardOutputLineAvailable(@NotNull String line) {
        String failedToStartBrowser;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/karma/server/KarmaServerState", "onStandardOutputLineAvailable"));
        }
        int serverPort = this.myBoundServerPort.get();
        if (serverPort == -1 && (serverPort = KarmaServerState.parseServerPort(line)) != -1 && this.myBoundServerPort.compareAndSet(-1, serverPort)) {
            this.myServer.fireOnPortBound();
        }
        if (!this.myBrowsersReady.get() && (failedToStartBrowser = KarmaServerState.parseFailedToStartBrowser(line)) != null) {
            LOG.info("Browser " + failedToStartBrowser + " failed to start: " + line);
            this.myFailedToStartBrowsers.add(failedToStartBrowser);
            if (this.canSetBrowsersReady()) {
                this.setBrowsersReady();
            }
        }
    }

    @Nullable
    private static String parseFailedToStartBrowser(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/karma/server/KarmaServerState", "parseFailedToStartBrowser"));
        }
        for (String[] pattern : FAILED_TO_START_BROWSER_PATTERNS) {
            String failedToStartBrowser = KarmaServerState.getInnerSubstring(line, pattern[0], pattern[1]);
            if (failedToStartBrowser == null) continue;
            return failedToStartBrowser;
        }
        return null;
    }

    private static int parseServerPort(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/karma/server/KarmaServerState", "parseServerPort"));
        }
        Matcher m = SERVER_PORT_LINE_PATTERN.matcher(text);
        if (m.find()) {
            String portStr = m.group(1);
            try {
                return Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                LOG.warn("Can't parse web server port from '" + text + "'");
            }
        }
        return -1;
    }

    @Nullable
    private static String getInnerSubstring(@NotNull String str, @NotNull String prefix, @NotNull String suffix) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/javascript/karma/server/KarmaServerState", "getInnerSubstring"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/javascript/karma/server/KarmaServerState", "getInnerSubstring"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/javascript/karma/server/KarmaServerState", "getInnerSubstring"));
        }
        if (str.startsWith(prefix) && str.endsWith(suffix) && prefix.length() + suffix.length() <= str.length()) {
            return str.substring(prefix.length(), str.length() - suffix.length());
        }
        return null;
    }

    private class ConfigHandler
    implements StreamEventHandler {
        private final File myConfigurationFileDir;

        public ConfigHandler(File configurationFile) {
            if (configurationFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFile", "com/intellij/javascript/karma/server/KarmaServerState$ConfigHandler", "<init>"));
            }
            this.myConfigurationFileDir = configurationFile.getParentFile();
        }

        @Override
        @NotNull
        public String getEventType() {
            if ("configFile" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServerState$ConfigHandler", "getEventType"));
            }
            return "configFile";
        }

        @Override
        public void handle(@NotNull JsonElement eventBody) {
            if (eventBody == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventBody", "com/intellij/javascript/karma/server/KarmaServerState$ConfigHandler", "handle"));
            }
            KarmaServerState.this.myConfig = KarmaConfig.parseFromJson(eventBody, this.myConfigurationFileDir);
        }
    }

    private class BrowserEventHandler
    implements StreamEventHandler {
        private final String myEventType;

        private BrowserEventHandler(String eventType) {
            if (eventType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/intellij/javascript/karma/server/KarmaServerState$BrowserEventHandler", "<init>"));
            }
            this.myEventType = eventType;
        }

        @Override
        @NotNull
        public String getEventType() {
            String string = this.myEventType;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/KarmaServerState$BrowserEventHandler", "getEventType"));
            }
            return string;
        }

        @Override
        public void handle(@NotNull JsonElement eventBody) {
            if (eventBody == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventBody", "com/intellij/javascript/karma/server/KarmaServerState$BrowserEventHandler", "handle"));
            }
            if (eventBody.isJsonObject()) {
                JsonObject event = eventBody.getAsJsonObject();
                String id = JsonUtil.getChildAsString((JsonObject)event, (String)"id");
                String name = JsonUtil.getChildAsString((JsonObject)event, (String)"name");
                Boolean autoCaptured = GsonUtil.getBooleanProperty(event, "isAutoCaptured");
                if (id != null && name != null) {
                    KarmaServerState.this.handleBrowsersChange(this.myEventType, id, name, autoCaptured);
                } else {
                    LOG.warn("Illegal browser event. Type: " + this.myEventType + ", body: " + eventBody.toString());
                }
            }
        }
    }
}

