/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server.watch;

import com.intellij.javascript.karma.server.KarmaServer;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;

public class KarmaChangedFilesManager {
    private final Object LOCK;
    private final PrintWriter myServerProcessInput;

    public KarmaChangedFilesManager(@NotNull KarmaServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/server/watch/KarmaChangedFilesManager", "<init>"));
        }
        this.LOCK = new Object();
        OutputStream outputStream = server.getProcessHandler().getProcessInput();
        this.myServerProcessInput = new PrintWriter(outputStream, false);
    }

    public void onFileChanged(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/karma/server/watch/KarmaChangedFilesManager", "onFileChanged"));
        }
        this.sendEvent("changed-file:", path);
    }

    public void onFileAdded(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/karma/server/watch/KarmaChangedFilesManager", "onFileAdded"));
        }
        this.sendEvent("added-file:", path);
    }

    public void onFileRemoved(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/karma/server/watch/KarmaChangedFilesManager", "onFileRemoved"));
        }
        this.sendEvent("removed-file:", path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(@NotNull String prefix, @NotNull String path) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/javascript/karma/server/watch/KarmaChangedFilesManager", "sendEvent"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/karma/server/watch/KarmaChangedFilesManager", "sendEvent"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myServerProcessInput.print(prefix);
            this.myServerProcessInput.print(path);
            this.myServerProcessInput.print("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myServerProcessInput.flush();
        }
    }
}

