/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server.watch;

import com.intellij.javascript.karma.server.watch.KarmaChangedFilesManager;
import com.intellij.javascript.karma.server.watch.KarmaWatchSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaWatchPattern {
    private static final Logger LOG = Logger.getInstance(KarmaWatchPattern.class);
    private static final Pattern[] BASE_DIR_PATTERNS = new Pattern[]{Pattern.compile("/[^/]*\\{.*\\}.*$"), Pattern.compile("/[^/]*\\*.*$"), Pattern.compile("/[^/]*!\\(.*$"), Pattern.compile("/[^/]*\\+\\(.*$"), Pattern.compile("/[^/]*\\)\\?.*$")};
    private final LocalFileSystem myFileSystem;
    private final KarmaChangedFilesManager myChangedFileManager;
    private final String myVfsPath;
    private final String myBasePathDir;
    private final boolean myCheckBasePathDir;
    private LocalFileSystem.WatchRequest myWatchRequest;
    private VirtualFile myRoot;
    private String myRootPath;

    KarmaWatchPattern(@NotNull LocalFileSystem fileSystem, @NotNull KarmaChangedFilesManager changedFilesManager, @NotNull String pattern) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/javascript/karma/server/watch/KarmaWatchPattern", "<init>"));
        }
        if (changedFilesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFilesManager", "com/intellij/javascript/karma/server/watch/KarmaWatchPattern", "<init>"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/javascript/karma/server/watch/KarmaWatchPattern", "<init>"));
        }
        LOG.info("Start watching path pattern " + pattern);
        this.myFileSystem = fileSystem;
        this.myChangedFileManager = changedFilesManager;
        this.myVfsPath = pattern.replace(File.separatorChar, '/');
        String baseDirPath = KarmaWatchPattern.extractBaseDir(this.myVfsPath);
        if (baseDirPath.isEmpty()) {
            baseDirPath = KarmaWatchSession.SEPARATOR;
        }
        this.myBasePathDir = baseDirPath;
        this.myCheckBasePathDir = !this.myVfsPath.equals(this.myBasePathDir);
        this.update(false);
    }

    @NotNull
    public static String extractBaseDir(@NotNull String filePattern) {
        if (filePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePattern", "com/intellij/javascript/karma/server/watch/KarmaWatchPattern", "extractBaseDir"));
        }
        for (Pattern pattern : BASE_DIR_PATTERNS) {
            filePattern = pattern.matcher(filePattern).replaceFirst("");
        }
        String string = filePattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/watch/KarmaWatchPattern", "extractBaseDir"));
        }
        return string;
    }

    public void update(boolean rescan) {
        String path;
        boolean rootValid;
        boolean noRootBefore = false;
        boolean bl = rootValid = this.myRoot != null && this.myRoot.isValid();
        if (rootValid && !(path = this.myRoot.getPath()).equals(this.myRootPath)) {
            rootValid = false;
            if (this.myRootPath != null) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file) {
                        String subPath;
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/karma/server/watch/KarmaWatchPattern$1", "visitFile"));
                        }
                        if (!file.isDirectory() && (subPath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)KarmaWatchPattern.this.myRoot, (char)'/')) != null) {
                            KarmaWatchPattern.this.myChangedFileManager.onFileRemoved(KarmaWatchSession.join(KarmaWatchPattern.this.myRootPath, subPath));
                        }
                        return true;
                    }
                });
            }
        }
        if (!rootValid) {
            VirtualFile baseDir;
            noRootBefore = true;
            this.myRoot = null;
            this.myRootPath = null;
            this.stopWatching();
            VirtualFile file = this.myFileSystem.findFileByPath(this.myVfsPath);
            if (file != null && file.isValid()) {
                this.myRoot = file;
            } else if (this.myCheckBasePathDir && (baseDir = this.myFileSystem.findFileByPath(this.myBasePathDir)) != null && baseDir.isValid()) {
                this.myRoot = baseDir;
            }
            if (this.myRoot != null) {
                this.myRootPath = this.myRoot.getPath();
            }
        }
        if (this.myRoot == null) {
            LOG.warn("[Karma watch] Can not find vfs root for " + this.myBasePathDir);
            return;
        }
        if (this.myWatchRequest == null) {
            this.myWatchRequest = this.watchRoot(this.myRoot, rescan && noRootBefore);
            LOG.info("Watching " + this.myRoot.getPath());
        }
    }

    @Nullable
    private LocalFileSystem.WatchRequest watchRoot(@NotNull VirtualFile dir, final boolean reportChildren) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/karma/server/watch/KarmaWatchPattern", "watchRoot"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/karma/server/watch/KarmaWatchPattern$2", "visitFile"));
                }
                if (reportChildren && !file.isDirectory()) {
                    KarmaWatchPattern.this.myChangedFileManager.onFileAdded(file.getPath());
                }
                file.getChildren();
                return true;
            }
        });
        LocalFileSystem.WatchRequest watchRequest = this.myFileSystem.addRootToWatch(dir.getPath(), true);
        if (watchRequest == null) {
            LOG.warn("Can not watch valid directory " + dir.getPath());
        }
        return watchRequest;
    }

    public void stopWatching() {
        LocalFileSystem.WatchRequest watchRequest = this.myWatchRequest;
        if (watchRequest != null) {
            this.myFileSystem.removeWatchedRoot(watchRequest);
        }
        this.myWatchRequest = null;
    }

    @Nullable
    public String findWatchedOriginalPath(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/karma/server/watch/KarmaWatchPattern", "findWatchedOriginalPath"));
        }
        VirtualFile root = this.myRoot;
        if (root != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) {
            String filePath = file.getPath();
            if (SystemInfo.isWindows) {
                String originalRoot;
                String string = originalRoot = this.myCheckBasePathDir ? this.myBasePathDir : this.myVfsPath;
                if (StringUtil.startsWithIgnoreCase((String)filePath, (String)originalRoot)) {
                    return originalRoot + filePath.substring(originalRoot.length());
                }
            }
            return filePath;
        }
        return null;
    }
}

