/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server.watch;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.watch.KarmaChangedFilesManager;
import com.intellij.javascript.karma.server.watch.KarmaWatchPattern;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaWatchSession {
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = String.valueOf('/');
    private final KarmaChangedFilesManager myChangedFilesManager;
    private final LocalFileSystem myFileSystem;
    private final ImmutableList<KarmaWatchPattern> myWatchPatterns;
    private final MyVirtualFileListener myVfsListener;

    public KarmaWatchSession(@NotNull KarmaServer server, @NotNull List<String> paths) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/server/watch/KarmaWatchSession", "<init>"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/javascript/karma/server/watch/KarmaWatchSession", "<init>"));
        }
        this.myVfsListener = new MyVirtualFileListener();
        this.myChangedFilesManager = new KarmaChangedFilesManager(server);
        this.myFileSystem = LocalFileSystem.getInstance();
        ArrayList watchPatterns = ContainerUtil.newArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (paths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/javascript/karma/server/watch/KarmaWatchSession", "lambda$new$0"));
            }
            for (String path : paths) {
                KarmaWatchPattern watchPattern = new KarmaWatchPattern(this.myFileSystem, this.myChangedFilesManager, path);
                watchPatterns.add(watchPattern);
            }
            this.myFileSystem.addVirtualFileListener((VirtualFileListener)this.myVfsListener);
        });
        this.myWatchPatterns = ImmutableList.copyOf((Collection)watchPatterns);
    }

    @Nullable
    private String findWatchedOriginalPath(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/karma/server/watch/KarmaWatchSession", "findWatchedOriginalPath"));
        }
        for (KarmaWatchPattern watchPattern : this.myWatchPatterns) {
            String watchedPath = watchPattern.findWatchedOriginalPath(file);
            if (watchedPath == null) continue;
            return watchedPath;
        }
        return null;
    }

    private void updateWatchPatterns() {
        for (KarmaWatchPattern pattern : this.myWatchPatterns) {
            pattern.update(true);
        }
    }

    public void stop() {
        ApplicationManager.getApplication().runReadAction(() -> {
            for (KarmaWatchPattern watchPattern : this.myWatchPatterns) {
                watchPattern.stopWatching();
            }
            this.myFileSystem.removeVirtualFileListener((VirtualFileListener)this.myVfsListener);
        });
    }

    public void flush() {
        this.myChangedFilesManager.flush();
    }

    @NotNull
    public static String join(@NotNull String path, @NotNull String subPath) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/karma/server/watch/KarmaWatchSession", "join"));
        }
        if (subPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subPath", "com/intellij/javascript/karma/server/watch/KarmaWatchSession", "join"));
        }
        if (path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        if (subPath.startsWith(SEPARATOR)) {
            subPath = subPath.substring(1);
        }
        String string = path + SEPARATOR + subPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/watch/KarmaWatchSession", "join"));
        }
        return string;
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            String parentWatchedPath;
            VirtualFile parent;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "propertyChanged"));
            }
            KarmaWatchSession.this.updateWatchPatterns();
            if ("name".equals(event.getPropertyName()) && (parent = event.getParent()) != null && (parentWatchedPath = KarmaWatchSession.this.findWatchedOriginalPath(parent)) != null) {
                String oldPath = KarmaWatchSession.join(parentWatchedPath, event.getOldValue().toString());
                String newPath = KarmaWatchSession.join(parentWatchedPath, event.getNewValue().toString());
                KarmaWatchSession.this.myChangedFilesManager.onFileRemoved(oldPath);
                KarmaWatchSession.this.myChangedFilesManager.onFileAdded(newPath);
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "contentsChanged"));
            }
            VirtualFile file = event.getFile();
            String watchedPath = KarmaWatchSession.this.findWatchedOriginalPath(file);
            if (watchedPath != null) {
                KarmaWatchSession.this.myChangedFilesManager.onFileChanged(watchedPath);
            }
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "fileCreated"));
            }
            KarmaWatchSession.this.updateWatchPatterns();
            VirtualFile file = event.getFile();
            String watchedPath = KarmaWatchSession.this.findWatchedOriginalPath(file);
            if (watchedPath != null) {
                KarmaWatchSession.this.myChangedFilesManager.onFileAdded(watchedPath);
            }
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "fileDeleted"));
            }
            KarmaWatchSession.this.updateWatchPatterns();
            VirtualFile file = event.getFile();
            String watchedPath = KarmaWatchSession.this.findWatchedOriginalPath(file);
            if (watchedPath != null) {
                KarmaWatchSession.this.myChangedFilesManager.onFileRemoved(watchedPath);
            }
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            VirtualFile newParent;
            String newParentWatchedPath;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "fileMoved"));
            }
            KarmaWatchSession.this.updateWatchPatterns();
            String fileName = event.getFileName();
            VirtualFile oldParent = event.getOldParent();
            String oldParentWatchedPath = KarmaWatchSession.this.findWatchedOriginalPath(oldParent);
            if (oldParentWatchedPath != null) {
                String oldPath = KarmaWatchSession.join(oldParentWatchedPath, fileName);
                KarmaWatchSession.this.myChangedFilesManager.onFileRemoved(oldPath);
            }
            if ((newParentWatchedPath = KarmaWatchSession.this.findWatchedOriginalPath(newParent = event.getNewParent())) != null) {
                String newPath = KarmaWatchSession.join(newParentWatchedPath, fileName);
                KarmaWatchSession.this.myChangedFilesManager.onFileAdded(newPath);
            }
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "fileCopied"));
            }
            KarmaWatchSession.this.updateWatchPatterns();
            VirtualFile file = event.getFile();
            String watchedPath = KarmaWatchSession.this.findWatchedOriginalPath(file);
            if (watchedPath != null) {
                KarmaWatchSession.this.myChangedFilesManager.onFileAdded(watchedPath);
            }
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "beforePropertyChange"));
            }
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "beforeContentsChange"));
            }
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "beforeFileDeletion"));
            }
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/watch/KarmaWatchSession$MyVirtualFileListener", "beforeFileMovement"));
            }
        }
    }
}

