/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server.watch;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.StreamEventHandler;
import com.intellij.javascript.karma.server.watch.KarmaWatchSession;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class KarmaWatcher {
    private final KarmaServer myServer;
    private volatile KarmaWatchSession mySession;

    public KarmaWatcher(@NotNull KarmaServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/server/watch/KarmaWatcher", "<init>"));
        }
        this.myServer = server;
    }

    @NotNull
    public StreamEventHandler getEventHandler() {
        StreamEventHandler streamEventHandler = new StreamEventHandler(){

            @Override
            @NotNull
            public String getEventType() {
                if ("configFilePatterns" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/watch/KarmaWatcher$1", "getEventType"));
                }
                return "configFilePatterns";
            }

            @Override
            public void handle(@NotNull JsonElement eventBody) {
                if (eventBody == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventBody", "com/intellij/javascript/karma/server/watch/KarmaWatcher$1", "handle"));
                }
                JsonArray patterns = eventBody.getAsJsonArray();
                ArrayList paths = ContainerUtil.newArrayListWithCapacity((int)patterns.size());
                for (JsonElement pattern : patterns) {
                    JsonPrimitive p = pattern.getAsJsonPrimitive();
                    paths.add(p.getAsString());
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> KarmaWatcher.this.mySession = new KarmaWatchSession(KarmaWatcher.this.myServer, paths));
            }
        };
        if (streamEventHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/server/watch/KarmaWatcher", "getEventHandler"));
        }
        return streamEventHandler;
    }

    public void flush() {
        if (this.mySession != null) {
            this.mySession.flush();
        }
    }

    public void stop() {
        if (this.mySession != null) {
            this.mySession.stop();
        }
    }
}

