/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.tree;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.filter.KarmaBrowserErrorFilter;
import com.intellij.javascript.karma.filter.KarmaSourceMapStacktraceFilter;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.testFramework.util.BrowserStacktraceFilters;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaTestProxyFilterProvider
implements TestProxyFilterProvider {
    private final Project myProject;
    private final KarmaServer myKarmaServer;

    public KarmaTestProxyFilterProvider(@NotNull Project project, @NotNull KarmaServer karmaServer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/tree/KarmaTestProxyFilterProvider", "<init>"));
        }
        if (karmaServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "karmaServer", "com/intellij/javascript/karma/tree/KarmaTestProxyFilterProvider", "<init>"));
        }
        this.myProject = project;
        this.myKarmaServer = karmaServer;
    }

    @Nullable
    public Filter getFilter(@NotNull String nodeType, @NotNull String nodeName, @Nullable String nodeArguments) {
        AbstractFileHyperlinkFilter browserFilter;
        String baseDir;
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/javascript/karma/tree/KarmaTestProxyFilterProvider", "getFilter"));
        }
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/javascript/karma/tree/KarmaTestProxyFilterProvider", "getFilter"));
        }
        KarmaConfig config = this.myKarmaServer.getKarmaConfig();
        String string = baseDir = config != null ? config.getBasePath() : null;
        if ("browser".equals(nodeType) && (browserFilter = BrowserStacktraceFilters.createFilter((String)nodeName, (Project)this.myProject, (String)baseDir)) != null) {
            return new KarmaSourceMapStacktraceFilter(this.myProject, baseDir, browserFilter);
        }
        if ("browserError".equals(nodeType)) {
            return this.getBrowserErrorFilter();
        }
        return null;
    }

    @Nullable
    private Filter getBrowserErrorFilter() {
        KarmaConfig karmaConfig = this.myKarmaServer.getKarmaConfig();
        if (karmaConfig != null) {
            return new KarmaBrowserErrorFilter(this.myProject, karmaConfig);
        }
        return null;
    }
}

