/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GsonUtil {
    private GsonUtil() {
    }

    @Nullable
    public static Boolean getBooleanProperty(@NotNull JsonObject jsonObject, @NotNull String propertyName) {
        JsonPrimitive primitive;
        if (jsonObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonObject", "com/intellij/javascript/karma/util/GsonUtil", "getBooleanProperty"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/javascript/karma/util/GsonUtil", "getBooleanProperty"));
        }
        JsonElement jsonElement = jsonObject.get(propertyName);
        if (jsonElement != null && jsonElement.isJsonPrimitive() && (primitive = jsonElement.getAsJsonPrimitive()).isBoolean()) {
            return primitive.getAsBoolean();
        }
        return null;
    }
}

