/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class KarmaUtil {
    public static final String NODE_PACKAGE_NAME = "karma";
    private static final String[] STARTING_PARTS = new String[]{"karma"};
    private static final String NAME_PART_DELIMITERS = ".-";
    private static final String[] BEFORE_EXT_PARTS = new String[]{"conf", "karma"};
    private static final String[] EXTENSIONS = new String[]{"js", "coffee", "es6", "ts"};
    private static final String[] MOST_RELEVANT_NAMES = new String[]{"karma.conf", "karma-conf", "karma-js.conf"};

    private KarmaUtil() {
    }

    public static void selectAndFocusIfNotDisposed(@NotNull RunnerLayoutUi ui, @NotNull Content content, boolean requestFocus, boolean forced) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/javascript/karma/util/KarmaUtil", "selectAndFocusIfNotDisposed"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/javascript/karma/util/KarmaUtil", "selectAndFocusIfNotDisposed"));
        }
        if (!ui.isDisposed()) {
            ui.selectAndFocus(content, requestFocus, forced);
        }
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/util/KarmaUtil", "listPossibleConfigFilesInProject"));
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList result = ContainerUtil.newArrayList();
        List fileTypes = JavaScriptFileType.getFileTypesCompilableToJavaScript();
        for (FileType type : fileTypes) {
            Collection files = FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)scope);
            for (VirtualFile file : files) {
                if (file == null || !file.isValid() || file.isDirectory() || !KarmaUtil.isKarmaConfigFile(file.getNameSequence(), false) || JSLibraryUtil.isProbableLibraryFile((VirtualFile)file)) continue;
                result.add(file);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/util/KarmaUtil", "listPossibleConfigFilesInProject"));
        }
        return arrayList;
    }

    public static boolean isKarmaConfigFile(@NotNull CharSequence filename, boolean matchMostRelevantNamesOnly) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/javascript/karma/util/KarmaUtil", "isKarmaConfigFile"));
        }
        int len = filename.length();
        int extensionInd = StringUtil.lastIndexOf((CharSequence)filename, (char)'.', (int)0, (int)len);
        if (extensionInd == -1) {
            return false;
        }
        boolean extMatched = false;
        for (String ext : EXTENSIONS) {
            if (ext.length() != len - extensionInd - 1 || !StringUtil.endsWith((CharSequence)filename, (CharSequence)ext)) continue;
            extMatched = true;
            break;
        }
        if (matchMostRelevantNamesOnly) {
            return KarmaUtil.isStartingPartMatched(filename, MOST_RELEVANT_NAMES);
        }
        if (!extMatched) {
            return false;
        }
        for (String beforeExtPart : BEFORE_EXT_PARTS) {
            int startOffset = extensionInd - beforeExtPart.length();
            if (startOffset <= 0 || !CharArrayUtil.regionMatches((CharSequence)filename, (int)startOffset, (CharSequence)beforeExtPart) || NAME_PART_DELIMITERS.indexOf(filename.charAt(startOffset - 1)) < 0) continue;
            return !StringUtil.contains((CharSequence)filename, (CharSequence)"protractor");
        }
        return KarmaUtil.isStartingPartMatched(filename, STARTING_PARTS);
    }

    private static boolean isStartingPartMatched(@NotNull CharSequence filename, @NotNull String[] startingParts) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/javascript/karma/util/KarmaUtil", "isStartingPartMatched"));
        }
        if (startingParts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startingParts", "com/intellij/javascript/karma/util/KarmaUtil", "isStartingPartMatched"));
        }
        for (String startingPart : startingParts) {
            if (startingPart.length() >= filename.length() || !CharArrayUtil.regionMatches((CharSequence)filename, (int)0, (CharSequence)startingPart) || NAME_PART_DELIMITERS.indexOf(filename.charAt(startingPart.length())) < 0) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile getRequester(@NotNull Project project, @NotNull String configFilePath) {
        File configFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/util/KarmaUtil", "getRequester"));
        }
        if (configFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePath", "com/intellij/javascript/karma/util/KarmaUtil", "getRequester"));
        }
        VirtualFile requester = null;
        if (StringUtil.isNotEmpty((String)configFilePath) && (configFile = new File(configFilePath)).isFile()) {
            requester = VfsUtil.findFileByIoFile((File)configFile, (boolean)false);
        }
        if (requester == null || !requester.isValid()) {
            requester = project.getBaseDir();
        }
        return requester;
    }

    public static boolean isPathUnderContentRoots(@NotNull Project project, @NotNull String filePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/util/KarmaUtil", "isPathUnderContentRoots"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/javascript/karma/util/KarmaUtil", "isPathUnderContentRoots"));
        }
        VirtualFile file = LocalFileFinder.findFile((String)FileUtil.toSystemIndependentName((String)filePath));
        if (file == null || !file.isValid()) {
            return false;
        }
        VirtualFile contentRoot = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file, false);
        return contentRoot != null;
    }

    @Nullable
    public static String detectKarmaPackageDir(@NotNull Project project, @NotNull String configFilePath, @NotNull NodeJsInterpreterRef interpreterRef) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/util/KarmaUtil", "detectKarmaPackageDir"));
        }
        if (configFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePath", "com/intellij/javascript/karma/util/KarmaUtil", "detectKarmaPackageDir"));
        }
        if (interpreterRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/javascript/karma/util/KarmaUtil", "detectKarmaPackageDir"));
        }
        ArrayList modules = ContainerUtil.newArrayList();
        VirtualFile requester = KarmaUtil.getRequester(project, configFilePath);
        NodeJsLocalInterpreter interpreter = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreterRef.resolve(project));
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)NODE_PACKAGE_NAME, (VirtualFile)requester, (NodeSettings)NodeSettings.create((NodeJsLocalInterpreter)interpreter), (boolean)true);
        for (CompletionModuleInfo module : modules) {
            VirtualFile moduleRoot = module.getVirtualFile();
            if (moduleRoot == null || !moduleRoot.isValid() || !moduleRoot.isDirectory()) continue;
            return FileUtil.toSystemDependentName((String)moduleRoot.getPath());
        }
        return null;
    }

    @NotNull
    public static RunContentDescriptor createDefaultDescriptor(@NotNull ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (executionResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/javascript/karma/util/KarmaUtil", "createDefaultDescriptor"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/karma/util/KarmaUtil", "createDefaultDescriptor"));
        }
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, environment);
        RunContentDescriptor runContentDescriptor = contentBuilder.showRunContent(environment.getContentToReuse());
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/util/KarmaUtil", "createDefaultDescriptor"));
        }
        return runContentDescriptor;
    }

    @NotNull
    public static RunProfileStarter createDefaultRunProfileStarter(final @NotNull ExecutionResult executionResult) {
        if (executionResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/javascript/karma/util/KarmaUtil", "createDefaultRunProfileStarter"));
        }
        RunProfileStarter runProfileStarter = new RunProfileStarter(){

            @Nullable
            public RunContentDescriptor execute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/karma/util/KarmaUtil$1", "execute"));
                }
                if (environment == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/karma/util/KarmaUtil$1", "execute"));
                }
                return KarmaUtil.createDefaultDescriptor(executionResult, environment);
            }
        };
        if (runProfileStarter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/util/KarmaUtil", "createDefaultRunProfileStarter"));
        }
        return runProfileStarter;
    }
}

