/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.util;

import com.intellij.javascript.karma.util.NodeInstalledPackage;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeInstalledPackagesLocator {
    private static final NodeInstalledPackagesLocator INSTANCE = new NodeInstalledPackagesLocator();
    private static final String[] FILE_EXTENSIONS = new String[]{".js", ".coffee", ".json", ".node"};

    @NotNull
    public static NodeInstalledPackagesLocator getInstance() {
        NodeInstalledPackagesLocator nodeInstalledPackagesLocator = INSTANCE;
        if (nodeInstalledPackagesLocator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "getInstance"));
        }
        return nodeInstalledPackagesLocator;
    }

    @Nullable
    public NodeInstalledPackage findInstalledPackages(@NotNull String packageName, @NotNull File currentDir, @Nullable NodeSettings nodeSettings) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "findInstalledPackages"));
        }
        if (currentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDir", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "findInstalledPackages"));
        }
        NodeInstalledPackage pkg = NodeInstalledPackagesLocator.findPackageInNodeModulesDir(packageName, currentDir);
        if (pkg != null) {
            return pkg;
        }
        if (nodeSettings != null && (pkg = NodeInstalledPackagesLocator.findPackageInGlobalFolders(packageName, nodeSettings)) != null) {
            return pkg;
        }
        return null;
    }

    @Nullable
    private static NodeInstalledPackage findPackageInGlobalFolders(@NotNull String packageName, @NotNull NodeSettings nodeSettings) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "findPackageInGlobalFolders"));
        }
        if (nodeSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeSettings", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "findPackageInGlobalFolders"));
        }
        List globalFolders = nodeSettings.getGlobalFolders();
        for (VirtualFile dir : globalFolders) {
            File ioDir;
            NodeInstalledPackage pkg;
            if (!dir.isValid() || !dir.isDirectory() || (pkg = NodeInstalledPackagesLocator.findPackageInDirectory(packageName, ioDir = new File(dir.getPath()))) == null) continue;
            return pkg;
        }
        return null;
    }

    @Nullable
    private static NodeInstalledPackage findPackageInNodeModulesDir(@NotNull String packageName, @NotNull File currentDir) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "findPackageInNodeModulesDir"));
        }
        if (currentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDir", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "findPackageInNodeModulesDir"));
        }
        for (File dir = currentDir; dir != null; dir = dir.getParentFile()) {
            NodeInstalledPackage pkg;
            File nodeModulesDir = new File(dir, "node_modules");
            if (!nodeModulesDir.isDirectory() || (pkg = NodeInstalledPackagesLocator.findPackageInDirectory(packageName, nodeModulesDir)) == null) continue;
            return pkg;
        }
        return null;
    }

    @Nullable
    private static NodeInstalledPackage findPackageInDirectory(@NotNull String packageName, @NotNull File dir) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "findPackageInDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "findPackageInDirectory"));
        }
        File packageDir = new File(dir, packageName);
        if (packageDir.isDirectory() && NodeInstalledPackagesLocator.canLoadDirectory(packageDir)) {
            return new NodeInstalledPackage(packageName, packageDir);
        }
        return null;
    }

    private static boolean canLoadDirectory(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/karma/util/NodeInstalledPackagesLocator", "canLoadDirectory"));
        }
        File packageJson = new File(dir, "package.json");
        if (packageJson.isFile()) {
            return true;
        }
        for (String ext : FILE_EXTENSIONS) {
            File file = new File(dir, "index" + ext);
            if (!file.isFile()) continue;
            return true;
        }
        return false;
    }
}

