/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.psi.SassScssFunctionBodyImpl;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;

public class AtKeywordsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final ArrayList<String> lookupElementsWithParentheses = Lists.newArrayList((Object[])new String[]{"@if", "@else if", "@for", "@each", "@while"});
    private static final ArrayList<String> lookupElementsWithSpace = Lists.newArrayList((Object[])new String[]{"@else", "@error", "@warn", "@debug", "@extend", "@mixin", "@include", "@function", "@at-root"});

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/sass/completion/AtKeywordsCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/AtKeywordsCompletionProvider", "addCompletions"));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), SassScssFunctionBodyImpl.class) != null) {
            result.addElement(SASSSCSSLangUtil.createKeywordLookupItem("@return", (InsertHandler<LookupElement>)AddSpaceInsertHandler.INSTANCE));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), SassScssMixinDeclaration.class) != null) {
            result.addElement(SASSSCSSLangUtil.createKeywordLookupItem("@content"));
        }
        result.addElement(SASSSCSSLangUtil.createKeywordLookupItem("@if", (InsertHandler<LookupElement>)ParenthesesInsertHandler.WITH_PARAMETERS));
        result.addAllElements(Iterables.transform(lookupElementsWithParentheses, (Function)new Function<String, LookupElement>(){

            public LookupElement apply(String input) {
                return SASSSCSSLangUtil.createKeywordLookupItem(input, (InsertHandler<LookupElement>)ParenthesesInsertHandler.WITH_PARAMETERS);
            }
        }));
        result.addAllElements(Iterables.transform(lookupElementsWithSpace, (Function)new Function<String, LookupElement>(){

            public LookupElement apply(String input) {
                return SASSSCSSLangUtil.createKeywordLookupItem(input, (InsertHandler<LookupElement>)AddSpaceInsertHandler.INSTANCE);
            }
        }));
    }
}

