/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;

public class AtRootNameInsertHandler
implements InsertHandler<LookupElement> {
    public void handleInsert(InsertionContext context, LookupElement item) {
        Project project;
        Editor editor = context.getEditor();
        if (context.getCompletionChar() == ':') {
            context.setAddCompletionChar(false);
        }
        if ((project = editor.getProject()) != null) {
            if (!AtRootNameInsertHandler.isCharAtCaret(editor, ':')) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)":");
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            } else {
                editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
            }
            if (!AtRootNameInsertHandler.isCharAtCaret(editor, ' ')) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            } else {
                editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
            }
        }
    }

    private static boolean isCharAtCaret(Editor editor, char ch) {
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == ch;
    }
}

