/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;

public class SassScssBraceInterpolationTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (file instanceof SassScssStylesheetFile && c == '{') {
            Document document = editor.getDocument();
            int offset = editor.getCaretModel().getOffset();
            CharSequence chars = document.getCharsSequence();
            if (offset > 0 && chars.charAt(offset - 1) == '#') {
                if (SassScssBraceInterpolationTypedHandler.alreadyHasEnding(chars, c, '}', offset)) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{}", (boolean)true, (int)1);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean alreadyHasEnding(CharSequence chars, char startChar, char endChar, int offset) {
        int i;
        for (i = offset; i < chars.length() && chars.charAt(i) != startChar && chars.charAt(i) != endChar && chars.charAt(i) != '\n'; ++i) {
        }
        return i < chars.length() && chars.charAt(i) == endChar;
    }
}

