/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemUtil {
    private static final String GEMS_DIRECTORY = "gems";
    private static final String RBENV_HOME_DIRECTORY_NAME = ".rbenv";
    private static final String RBENV_HOME_VARIABLE = "RBENV_ROOT";
    private static final String RBENV_RUBIES_DIRECTORY = "versions";
    private static final String RBENV_GEMS_RELATIVE_PATH = "lib/ruby/gems";
    private static final String RVM_HOME_DIRECTORY_NAME = ".rvm";
    private static final String RVM_HOME_VARIABLE = "rvm_path";
    private static final String RVM_SYSTEM_WIDE_PATH = "/usr/local/rvm";
    private static final String RVM_RUBIES_DIRECTORY = "rubies";

    @NotNull
    public static Collection<? extends VirtualFile> findGems(@NotNull String gemName) {
        if (gemName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gemName", "org/jetbrains/plugins/sass/extensions/GemUtil", "findGems"));
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        result.addAll(GemUtil.findRvmGems(gemName));
        result.addAll(GemUtil.findRbenvGems(gemName));
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/GemUtil", "findGems"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static List<String> listPossibleExecutableFilePaths(@NotNull String executableFileName, @NotNull String executableRelativePath) {
        if (executableFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executableFileName", "org/jetbrains/plugins/sass/extensions/GemUtil", "listPossibleExecutableFilePaths"));
        }
        if (executableRelativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executableRelativePath", "org/jetbrains/plugins/sass/extensions/GemUtil", "listPossibleExecutableFilePaths"));
        }
        List list = ContainerUtil.map(GemUtil.listPossibleExecutableFiles(executableFileName, executableRelativePath), file -> file.getPath());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/GemUtil", "listPossibleExecutableFilePaths"));
        }
        return list;
    }

    public static boolean isValidExecutableFile(@Nullable VirtualFile executableFile) {
        return executableFile != null && executableFile.exists() && !executableFile.isDirectory();
    }

    @NotNull
    public static Set<VirtualFile> listPossibleExecutableFiles(@NotNull String executableFileName, @NotNull String executableRelativePath) {
        if (executableFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executableFileName", "org/jetbrains/plugins/sass/extensions/GemUtil", "listPossibleExecutableFiles"));
        }
        if (executableRelativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executableRelativePath", "org/jetbrains/plugins/sass/extensions/GemUtil", "listPossibleExecutableFiles"));
        }
        LinkedHashSet interpreters = ContainerUtil.newLinkedHashSet();
        List path = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)executableFileName);
        for (File file : path) {
            VirtualFile compassExecutableFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            if (!GemUtil.isValidExecutableFile(compassExecutableFile)) continue;
            interpreters.add(compassExecutableFile);
        }
        for (VirtualFile virtualFile : GemUtil.findGems(executableFileName)) {
            GemUtil.populateWithExecutableFilesFromGemDirectory(virtualFile, interpreters, executableRelativePath);
        }
        LinkedHashSet linkedHashSet = interpreters;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/GemUtil", "listPossibleExecutableFiles"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<? extends VirtualFile> findRbenvGems(@NotNull String gemName) {
        VirtualFile versionsDirectory;
        VirtualFile rbenvHome;
        if (gemName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gemName", "org/jetbrains/plugins/sass/extensions/GemUtil", "findRbenvGems"));
        }
        if (SystemInfo.isUnix && (rbenvHome = GemUtil.getRbenvHome()) != null && (versionsDirectory = rbenvHome.findFileByRelativePath(RBENV_RUBIES_DIRECTORY)) != null && versionsDirectory.isDirectory()) {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            Pattern gemNamePattern = GemUtil.createGemNamePattern(gemName);
            for (VirtualFile versionDirectory : versionsDirectory.getChildren()) {
                VirtualFile versionGemsDirectory = versionDirectory.findFileByRelativePath(RBENV_GEMS_RELATIVE_PATH);
                if (versionGemsDirectory == null || !versionGemsDirectory.isDirectory()) continue;
                for (VirtualFile subversionDirectory : versionGemsDirectory.getChildren()) {
                    VirtualFile gemsDirectory = subversionDirectory.findFileByRelativePath(GEMS_DIRECTORY);
                    if (gemsDirectory == null || !gemsDirectory.isDirectory()) continue;
                    for (VirtualFile gem : gemsDirectory.getChildren()) {
                        if (!gem.isDirectory() || !gemNamePattern.matcher(gem.getName()).matches()) continue;
                        result.add(gem);
                    }
                }
            }
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/GemUtil", "findRbenvGems"));
            }
            return linkedHashSet;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/GemUtil", "findRbenvGems"));
        }
        return set;
    }

    @NotNull
    private static Collection<? extends VirtualFile> findRvmGems(@NotNull String gemName) {
        VirtualFile versionsDirectory;
        VirtualFile rvmHome;
        if (gemName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gemName", "org/jetbrains/plugins/sass/extensions/GemUtil", "findRvmGems"));
        }
        if (SystemInfo.isUnix && (rvmHome = GemUtil.getRvmHome()) != null && (versionsDirectory = rvmHome.findChild(GEMS_DIRECTORY)) != null && versionsDirectory.isDirectory() && versionsDirectory.getChildren().length > 0) {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            Pattern gemNamePattern = GemUtil.createGemNamePattern(gemName);
            for (VirtualFile rubyDirectory : versionsDirectory.getChildren()) {
                VirtualFile gemsDirectory = rubyDirectory.findFileByRelativePath(GEMS_DIRECTORY);
                if (gemsDirectory == null || !gemsDirectory.isDirectory()) continue;
                for (VirtualFile gem : gemsDirectory.getChildren()) {
                    if (!gem.isDirectory() || !gemNamePattern.matcher(gem.getName()).matches()) continue;
                    result.add(gem);
                }
            }
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/GemUtil", "findRvmGems"));
            }
            return linkedHashSet;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/GemUtil", "findRvmGems"));
        }
        return set;
    }

    @Nullable
    private static VirtualFile getRbenvHome() {
        VirtualFile rubyHome = GemUtil.findRubyHomeFromEnvironmentVariable(RBENV_HOME_VARIABLE);
        return rubyHome != null ? rubyHome : GemUtil.findRubyHomeInUserDirectory(RBENV_HOME_DIRECTORY_NAME);
    }

    @Nullable
    private static VirtualFile getRvmHome() {
        VirtualFile systemWideRvmHome;
        VirtualFile rvmHome = GemUtil.findRubyHomeFromEnvironmentVariable(RVM_HOME_VARIABLE);
        if (rvmHome == null && (rvmHome = GemUtil.findRubyHomeInUserDirectory(RVM_HOME_DIRECTORY_NAME)) == null && GemUtil.isValidRubyHome(systemWideRvmHome = VirtualFileManager.getInstance().refreshAndFindFileByUrl(RVM_SYSTEM_WIDE_PATH))) {
            assert (systemWideRvmHome != null);
            VirtualFile markerDirectory = systemWideRvmHome.findChild(RVM_RUBIES_DIRECTORY);
            if (GemUtil.isValidRubyHome(markerDirectory)) {
                rvmHome = systemWideRvmHome;
            }
        }
        return rvmHome;
    }

    @Nullable
    private static VirtualFile findRubyHomeFromEnvironmentVariable(@NotNull String variableName) {
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "org/jetbrains/plugins/sass/extensions/GemUtil", "findRubyHomeFromEnvironmentVariable"));
        }
        String pathFromEnvironmentVariable = EnvironmentUtil.getValue((String)variableName);
        if (!StringUtil.isEmpty((String)pathFromEnvironmentVariable)) {
            String possibleRubyHomePath = VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)pathFromEnvironmentVariable));
            VirtualFile rubyHome = VirtualFileManager.getInstance().refreshAndFindFileByUrl(possibleRubyHomePath);
            if (GemUtil.isValidRubyHome(rubyHome)) {
                return rubyHome;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findRubyHomeInUserDirectory(@NotNull String rubyHomeDirectoryName) {
        VirtualFile rvmHome;
        if (rubyHomeDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rubyHomeDirectoryName", "org/jetbrains/plugins/sass/extensions/GemUtil", "findRubyHomeInUserDirectory"));
        }
        VirtualFile userHomeFolder = VfsUtil.getUserHomeDir();
        if (userHomeFolder != null && GemUtil.isValidRubyHome(rvmHome = userHomeFolder.findChild(rubyHomeDirectoryName))) {
            return rvmHome;
        }
        return null;
    }

    @NotNull
    private static Pattern createGemNamePattern(@NotNull String gemName) {
        if (gemName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gemName", "org/jetbrains/plugins/sass/extensions/GemUtil", "createGemNamePattern"));
        }
        Pattern pattern = Pattern.compile(StringUtil.escapePattern((String)gemName) + "-\\d.*");
        if (pattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/GemUtil", "createGemNamePattern"));
        }
        return pattern;
    }

    private static boolean isValidRubyHome(@Nullable VirtualFile rvmHome) {
        if (rvmHome == null) {
            return false;
        }
        return rvmHome.exists() && rvmHome.isDirectory() && rvmHome.getChildren().length > 0;
    }

    private static void populateWithExecutableFilesFromGemDirectory(@NotNull VirtualFile gemsDirectory, @NotNull Set<VirtualFile> interpreters, @NotNull String relativePathInGem) {
        if (gemsDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gemsDirectory", "org/jetbrains/plugins/sass/extensions/GemUtil", "populateWithExecutableFilesFromGemDirectory"));
        }
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "org/jetbrains/plugins/sass/extensions/GemUtil", "populateWithExecutableFilesFromGemDirectory"));
        }
        if (relativePathInGem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePathInGem", "org/jetbrains/plugins/sass/extensions/GemUtil", "populateWithExecutableFilesFromGemDirectory"));
        }
        VirtualFile compassExecutableFile = gemsDirectory.findFileByRelativePath(relativePathInGem);
        if (GemUtil.isValidExecutableFile(compassExecutableFile)) {
            interpreters.add(compassExecutableFile);
        }
    }

    private GemUtil() {
    }
}

