/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelperImpl;
import org.jetbrains.plugins.sass.extensions.compass.CompassConfigurable;
import org.jetbrains.plugins.sass.extensions.compass.CompassSassExtension;

public abstract class SassRubyIntegrationHelper {
    public static final ExtensionPointName<SassRubyIntegrationHelper> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.sass.rubyIntegrationHelper");
    public static boolean doNotUseRubyPlugin = false;
    private static final SassRubyIntegrationHelper DEFAULT_INSTANCE = new SassRubyIntegrationHelperImpl();

    @NotNull
    public static SassRubyIntegrationHelper getInstance() {
        SassRubyIntegrationHelper result;
        SassRubyIntegrationHelper[] extensions = (SassRubyIntegrationHelper[])EXTENSION_POINT_NAME.getExtensions();
        SassRubyIntegrationHelper sassRubyIntegrationHelper = result = extensions.length > 0 ? extensions[0] : DEFAULT_INSTANCE;
        if (ApplicationManager.getApplication().isUnitTestMode() && doNotUseRubyPlugin) {
            SassRubyIntegrationHelper sassRubyIntegrationHelper2 = DEFAULT_INSTANCE;
            if (sassRubyIntegrationHelper2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelper", "getInstance"));
            }
            return sassRubyIntegrationHelper2;
        }
        SassRubyIntegrationHelper sassRubyIntegrationHelper3 = result;
        if (sassRubyIntegrationHelper3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelper", "getInstance"));
        }
        return sassRubyIntegrationHelper3;
    }

    public abstract void fillCompletionResultWithExtensionFunctions(@NotNull CompletionResultSet var1, @NotNull Project var2, @NotNull GlobalSearchScope var3);

    @NotNull
    public abstract Collection<? extends SassExtensionFunctionInfo> findExtensionFunctions(@NotNull String var1, @NotNull Project var2, @NotNull GlobalSearchScope var3);

    public boolean isSassExtensionLookupObject(@Nullable Object object) {
        return object instanceof SassExtensionFunctionInfo;
    }

    public abstract boolean hasRubyPlugin();

    public abstract boolean isRubyModule(@NotNull Module var1);

    public ProcessOutput execScript(@NotNull Module module, @Nullable String workingDirectory, @NotNull String command, String ... parameters) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelper", "execScript"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelper", "execScript"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelper", "execScript"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{command});
        if (parameters.length > 0) {
            commandLine.addParameters(parameters);
        }
        commandLine.withWorkDirectory(workingDirectory);
        OSProcessHandler processHandler = new OSProcessHandler(commandLine);
        ProcessOutput output = new ProcessOutput();
        processHandler.addProcessListener((ProcessListener)new CapturingProcessAdapter(output));
        processHandler.startNotify();
        int timeout = Registry.intValue((String)"command.line.execution.timeout");
        ExecutionHelper.executeExternalProcess((Project)module.getProject(), (ProcessHandler)processHandler, (ExecutionMode)new ExecutionModes.SameThreadMode(timeout), (GeneralCommandLine)commandLine);
        return output;
    }

    public static void doNotUseRubyPlugin(boolean value) {
        doNotUseRubyPlugin = value;
    }

    public abstract boolean isGemInstalled(@NotNull String var1, @NotNull Module var2);

    @NotNull
    public Configurable createCompassConfigurable(@NotNull Module module, boolean fullMode) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelper", "createCompassConfigurable"));
        }
        CompassConfigurable compassConfigurable = new CompassConfigurable(module, (CompassSassExtension)SassExtension.EXTENSION_POINT_NAME.findExtension(CompassSassExtension.class), fullMode);
        if (compassConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelper", "createCompassConfigurable"));
        }
        return compassConfigurable;
    }
}

