/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.highlighting;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.highlighting.SassScssHighlightingColors;
import org.jetbrains.plugins.sass.lexer.SASSHighlighterLexer;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;

public class SASSSyntaxHighlighter
extends CssHighlighter {
    private static final Map<IElementType, TextAttributesKey> mapping = ContainerUtil.newHashMap();
    private static final Map<IElementType, TextAttributesKey> backwardCompatibility = ContainerUtil.newHashMap();

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (backwardCompatibility.containsKey(tokenType) || mapping.containsKey(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = SASSSyntaxHighlighter.pack((TextAttributesKey)backwardCompatibility.get(tokenType), (TextAttributesKey)mapping.get(tokenType));
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/highlighting/SASSSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/highlighting/SASSSyntaxHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        SASSHighlighterLexer sASSHighlighterLexer = new SASSHighlighterLexer(CssElementDescriptorFactory2.getInstance().getValueIdentifiers());
        if (sASSHighlighterLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/highlighting/SASSSyntaxHighlighter", "getHighlightingLexer"));
        }
        return sASSHighlighterLexer;
    }

    static {
        mapping.put(SASSTokenTypes.MIXIN, SassScssHighlightingColors.MIXIN);
        mapping.put(CssElementTypes.CSS_HASH, SassScssHighlightingColors.ID_SELECTOR);
        mapping.put(SASSTokenTypes.IDENTIFIER, SassScssHighlightingColors.IDENTIFIER);
        mapping.put(SASSTokenTypes.AMPERSAND, SassScssHighlightingColors.IDENTIFIER);
        mapping.put(SASSTokenTypes.STRING, SassScssHighlightingColors.STRING);
        mapping.put(SASSTokenTypes.NUMBER, SassScssHighlightingColors.NUMBER);
        mapping.put(SASSTokenTypes.VARIABLE, SassScssHighlightingColors.VARIABLE);
        mapping.put(SASSTokenTypes.EXTEND_TOKEN, SassScssHighlightingColors.EXTEND);
        mapping.put(SASSTokenTypes.IMPORTANT, SassScssHighlightingColors.IMPORTANT);
        mapping.put(SASSTokenTypes.GLOBAL, SassScssHighlightingColors.GLOBAL);
        mapping.put(SASSTokenTypes.DEFAULT, SassScssHighlightingColors.DEFAULT);
        mapping.put(SASSTokenTypes.DYNAMIC, SassScssHighlightingColors.DYNAMIC);
        mapping.put(SASSTokenTypes.OPTIONAL, SassScssHighlightingColors.OPTIONAL);
        mapping.put(SASSTokenTypes.PROPERTY_NAME, SassScssHighlightingColors.PROPERTY_NAME);
        mapping.put(SASSTokenTypes.PROPERTY_VALUE, SassScssHighlightingColors.PROPERTY_VALUE);
        mapping.put(SASSTokenTypes.TAG_NAME, SassScssHighlightingColors.TAG_NAME);
        mapping.put(SASSTokenTypes.FUNCTION_TOKEN, SassScssHighlightingColors.FUNCTION);
        mapping.put(CssElementTypes.CSS_URI_START, SassScssHighlightingColors.FUNCTION);
        mapping.put(CssElementTypes.CSS_URL, SassScssHighlightingColors.URL);
        mapping.put(CssElementTypes.CSS_COLOR, SassScssHighlightingColors.COLOR);
        mapping.put(CssElementTypes.CSS_PSEUDO, SassScssHighlightingColors.PSEUDO);
        mapping.put(CssElementTypes.CSS_UNICODE_RANGE, SassScssHighlightingColors.UNICODE_RANGE);
        mapping.put(CssElementTypes.CSS_LPAREN, SassScssHighlightingColors.PARENTHESES);
        mapping.put(CssElementTypes.CSS_RPAREN, SassScssHighlightingColors.PARENTHESES);
        mapping.put(CssElementTypes.CSS_LBRACE, SassScssHighlightingColors.BRACES);
        mapping.put(CssElementTypes.CSS_RBRACE, SassScssHighlightingColors.BRACES);
        mapping.put(CssElementTypes.CSS_LBRACKET, SassScssHighlightingColors.BRACKETS);
        mapping.put(CssElementTypes.CSS_RBRACKET, SassScssHighlightingColors.BRACKETS);
        mapping.put(CssElementTypes.CSS_PERIOD, SassScssHighlightingColors.DOT);
        mapping.put(CssElementTypes.CSS_COLON, SassScssHighlightingColors.COLON);
        mapping.put(CssElementTypes.CSS_COMMA, SassScssHighlightingColors.COMMA);
        mapping.put(CssElementTypes.CSS_SEMICOLON, SassScssHighlightingColors.SEMICOLON);
        mapping.put(SASSTokenTypes.INTERPOLATION_PREFIX, SassScssHighlightingColors.INTERPOLATION);
        mapping.put(SASSTokenTypes.INTERPOLATION_SUFFIX, SassScssHighlightingColors.INTERPOLATION);
        mapping.put(CssElementTypes.CSS_BAD_CHARACTER, SassScssHighlightingColors.BAD_CHARACTER);
        backwardCompatibility.put(CssElementTypes.CSS_HASH, CssHighlighter.CSS_IDENT);
        backwardCompatibility.put(SASSTokenTypes.IDENTIFIER, CssHighlighter.CSS_IDENT);
        backwardCompatibility.put(SASSTokenTypes.STRING, CssHighlighter.CSS_STRING);
        backwardCompatibility.put(SASSTokenTypes.NUMBER, CssHighlighter.CSS_NUMBER);
        backwardCompatibility.put(SASSTokenTypes.IMPORTANT, CssHighlighter.CSS_IMPORTANT);
        backwardCompatibility.put(SASSTokenTypes.DEFAULT, CssHighlighter.CSS_IMPORTANT);
        backwardCompatibility.put(SASSTokenTypes.PROPERTY_NAME, CssHighlighter.CSS_PROPERTY_NAME);
        backwardCompatibility.put(SASSTokenTypes.PROPERTY_VALUE, CssHighlighter.CSS_PROPERTY_VALUE);
        backwardCompatibility.put(SASSTokenTypes.TAG_NAME, CssHighlighter.CSS_TAG_NAME);
        backwardCompatibility.put(SASSTokenTypes.FUNCTION_TOKEN, CssHighlighter.CSS_FUNCTION);
        backwardCompatibility.put(CssElementTypes.CSS_URI_START, CssHighlighter.CSS_FUNCTION);
        backwardCompatibility.put(CssElementTypes.CSS_URL, CssHighlighter.CSS_URL);
        for (IElementType type : SASSTokenTypes.COMMENTS.getTypes()) {
            mapping.put(type, SassScssHighlightingColors.COMMENT);
        }
        for (IElementType type : SASSTokenTypes.KEYWORDS.getTypes()) {
            mapping.put(type, SassScssHighlightingColors.KEYWORD);
        }
        for (IElementType type : SASSTokenTypes.OPERATORS.getTypes()) {
            mapping.put(type, SassScssHighlightingColors.OPERATORS);
        }
        HtmlFileHighlighter.registerEmbeddedTokenAttributes(backwardCompatibility, mapping);
        XmlFileHighlighter.registerEmbeddedTokenAttributes(backwardCompatibility, mapping);
    }
}

