/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSLanguage;

public class SASSLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        SASSLanguage sASSLanguage = SASSLanguage.INSTANCE;
        if (sASSLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/settings/SASSLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return sASSLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "org/jetbrains/plugins/sass/settings/SASSLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return "table.hl\n  margin: 2em 0\n  td.ln\n    text-align: right\n\nli\n  font:\n    family: serif\n    weight: bold\n    size: 1.2em";
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings((Language)SASSLanguage.INSTANCE);
        defaultSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        defaultSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = defaultSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        return defaultSettings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }
}

