/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssFormattingElementVisitor;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.psi.SASSElementTypes;
import org.jetbrains.plugins.scss.SCSSElementTypes;
import org.jetbrains.plugins.scss.formatter.SCSSRulesetBlock;
import org.jetbrains.plugins.scss.formatter.ScssRootBlock;
import org.jetbrains.plugins.scss.formatter.ScssVariableDeclarationBlock;
import org.jetbrains.plugins.scss.lexer.SCSSTokenTypes;
import org.jetbrains.plugins.scss.psi.SCSSInterpolationImpl;
import org.jetbrains.plugins.scss.psi.SCSSOperationImpl;
import org.jetbrains.plugins.scss.psi.SassScssFunctionBodyImpl;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssRuleset;
import org.jetbrains.plugins.scss.psi.SassScssStatement;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;

public class SCSSFormattingModelBuilder
extends CssFormattingModelBuilder {
    private static final TokenSet CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_DECLARATION_BLOCK, CssElementTypes.CSS_PAGE_BLOCK, CssElementTypes.CSS_KEYFRAMES_RULE, SASSElementTypes.DECLARATION_BLOCK, SCSSElementTypes.SCSS_FUNCTION_BODY, SCSSElementTypes.SCSS_PROPERTY_RULESET});

    protected CssFormattingModelBuilder.CssFormattingExtension createExtension() {
        return ScssFormattingExtension.INSTANCE;
    }

    protected static class ScssFormattingExtension
    extends CssFormattingModelBuilder.CssFormattingExtension {
        static final ScssFormattingExtension INSTANCE = new ScssFormattingExtension();

        protected ScssFormattingExtension() {
        }

        public boolean isComment(IElementType elementType) {
            return SCSSTokenTypes.COMMENTS.contains(elementType) || super.isComment(elementType);
        }

        public boolean isLineComment(IElementType elementType) {
            return SCSSTokenTypes.COMMENT == elementType || super.isComment(elementType);
        }

        public boolean addSubBlocks(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength, List<Block> result) {
            if (element instanceof SassScssPropertyRuleset) {
                result.add((Block)this.createRulesetBlock(element.getNode(), settings, Indent.getNormalIndent(), maxPropertyLength, this, null));
                return true;
            }
            return false;
        }

        public boolean addSubBlocksOfExtendedLanguage(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength, List<Block> result) {
            Alignment alignment;
            Indent indent = this.isContainer(element.getParent().getNode().getElementType()) ? Indent.getNormalIndent() : Indent.getNoneIndent();
            Object object = alignment = settings.VALUE_ALIGNMENT == 2 || settings.VALUE_ALIGNMENT == 1 ? Alignment.createAlignment((boolean)true) : null;
            if (element instanceof SassScssVariableDeclaration) {
                result.add((Block)new ScssVariableDeclarationBlock(element.getNode(), settings, indent, maxPropertyLength, this, element.getTextLength(), null, alignment));
                return true;
            }
            if (element instanceof SassScssVariableImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), settings, Indent.getNoneIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element.getNode().getElementType() == SCSSElementTypes.MAP) {
                result.add((Block)new SassScssMapFormatterBlock(element, settings, maxPropertyLength));
                return true;
            }
            if (element.getNode().getElementType() == SCSSElementTypes.MAP_ENTRY) {
                result.add((Block)new SassScssMapEntryFormatterBlock(element, settings, maxPropertyLength));
                return true;
            }
            if (element instanceof SassScssInclude) {
                if (PsiTreeUtil.getNextSiblingOfType((PsiElement)element, CssBlock.class) != null) {
                    indent = Indent.getNoneIndent();
                }
                result.add((Block)new CssFormattingModelBuilder.CssPropertyBlock(element.getNode(), settings, indent, maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this, element.getTextLength(), null, alignment));
                return true;
            }
            if (element instanceof SassScssRuleset) {
                result.add((Block)this.createRulesetBlock(element.getNode(), settings, indent, maxPropertyLength, this, null));
                return true;
            }
            if (element instanceof SassScssFunctionBodyImpl) {
                element.acceptChildren((PsiElementVisitor)new CssFormattingElementVisitor(result, settings, maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this, null, null, (IElementType)SCSSElementTypes.SCSS_FUNCTION_BODY, true));
                return true;
            }
            if (element instanceof SassScssStatement) {
                result.add((Block)this.createPropertyBlock(element.getNode(), settings, maxPropertyLength, this, element.getTextLength(), null, alignment));
                return true;
            }
            if (element instanceof SCSSInterpolationImpl) {
                result.add((Block)new CssFormattingModelBuilder.LeafBlock(element.getNode(), Indent.getNoneIndent()));
                return true;
            }
            if (element instanceof SCSSOperationImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), settings, Indent.getNoneIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element.getNode().getElementType() == SCSSElementTypes.SCSS_PARENTHESIS_EXPRESSION) {
                result.add((Block)this.createTermListBlock(element.getNode(), settings, Indent.getContinuationIndent(), maxPropertyLength, -1, null, true));
                return true;
            }
            return false;
        }

        protected boolean isContainer(@Nullable IElementType elementType) {
            return CONTAINERS.contains(elementType);
        }

        public CssFormattingModelBuilder.CssRootBlock createRootBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new ScssRootBlock(_node, settings, maxPropertyLength, extension);
        }

        public CssFormattingModelBuilder.CssRulesetBlock createRulesetBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension, @Nullable Alignment alignment) {
            return new SCSSRulesetBlock(_node, settings, indent, maxPropertyLength, extension, alignment);
        }

        public CssFormattingModelBuilder.CssPropertyBlock createPropertyBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension, int nameLength, @Nullable Alignment alignment, Alignment childAlignment) {
            Indent indent = _node.getTreeParent().getElementType() == SASSElementTypes.PROPERTY_RULESET || PsiTreeUtil.getParentOfType((PsiElement)_node.getPsi(), CssBlock.class) == null && PsiTreeUtil.getParentOfType((PsiElement)_node.getPsi(), SassScssFunctionBodyImpl.class) == null ? Indent.getNoneIndent() : Indent.getNormalIndent();
            return super.createPropertyBlock(_node, settings, indent, maxPropertyLength, extension, nameLength, alignment, childAlignment);
        }

        public CssFormattingModelBuilder.CssFormatterBlock createMediaBlock(ASTNode node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return this.createRulesetBlock(node, settings, indent, maxPropertyLength, extension, null);
        }

        public CssFormattingModelBuilder.CssFormatterBlock createSupportsBlock(ASTNode node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return this.createRulesetBlock(node, settings, indent, maxPropertyLength, extension, null);
        }

        private class SassScssMapEntryFormatterBlock
        extends CssFormattingModelBuilder.CssFormatterBlock {
            public SassScssMapEntryFormatterBlock(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength) {
                super(element.getNode(), settings, Indent.getContinuationIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)ScssFormattingExtension.this);
            }

            public boolean shouldIndentContent() {
                return false;
            }

            @Nullable
            public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
                if (child2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/scss/formatter/SCSSFormattingModelBuilder$ScssFormattingExtension$SassScssMapEntryFormatterBlock", "getSpacing"));
                }
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)1);
            }

            @NotNull
            public ChildAttributes getChildAttributes(int newChildIndex) {
                ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/formatter/SCSSFormattingModelBuilder$ScssFormattingExtension$SassScssMapEntryFormatterBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
        }

        private class SassScssMapFormatterBlock
        extends CssFormattingModelBuilder.CssFormatterBlock {
            public SassScssMapFormatterBlock(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength) {
                super(element.getNode(), settings, Indent.getNoneIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)ScssFormattingExtension.this);
            }

            @Nullable
            public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
                if (child2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/scss/formatter/SCSSFormattingModelBuilder$ScssFormattingExtension$SassScssMapFormatterBlock", "getSpacing"));
                }
                if (!(child1 instanceof CssFormattingModelBuilder.CssFormatterBlock) || !(child2 instanceof CssFormattingModelBuilder.CssFormatterBlock)) {
                    return null;
                }
                CssFormattingModelBuilder.CssFormatterBlock formatterBlock = (CssFormattingModelBuilder.CssFormatterBlock)child1;
                CssFormattingModelBuilder.CssFormatterBlock formatterBlock2 = (CssFormattingModelBuilder.CssFormatterBlock)child2;
                if (formatterBlock2.myType == CssElementTypes.CSS_COMMA) {
                    return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                }
                if (formatterBlock.myType == CssElementTypes.CSS_LPAREN || formatterBlock2.myType == CssElementTypes.CSS_RPAREN) {
                    return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)0);
                }
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }

            public boolean shouldIndentContent() {
                return true;
            }

            @NotNull
            public ChildAttributes getChildAttributes(int newChildIndex) {
                ChildAttributes childAttributes = new ChildAttributes(Indent.getContinuationIndent(), null);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/formatter/SCSSFormattingModelBuilder$ScssFormattingExtension$SassScssMapFormatterBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
        }
    }
}

