/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.scss.inspections.SassScssBaseInspection;
import org.jetbrains.plugins.scss.psi.SASSSCSSElementVisitor;
import org.jetbrains.plugins.scss.psi.SassScssPlaceholderSelectorImpl;

public class SassScssUnresolvedPlaceholderSelectorInspection
extends SassScssBaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = SASSBundle.message("inspections.unresolved.placeholder.selector.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssUnresolvedPlaceholderSelectorInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/scss/inspections/SassScssUnresolvedPlaceholderSelectorInspection", "buildVisitor"));
        }
        SASSSCSSElementVisitor sASSSCSSElementVisitor = new SASSSCSSElementVisitor(){

            @Override
            public void visitPlaceholderSelector(SassScssPlaceholderSelectorImpl selector) {
                PsiReference[] references = selector.getReferences();
                PsiElement nameIdentifier = selector.getNameIdentifier();
                if (selector.isInsideExtendStatement() && nameIdentifier != null && !selector.getName().isEmpty() && references.length == 1 && references[0] instanceof PsiPolyVariantReference) {
                    if (((PsiPolyVariantReference)references[0]).multiResolve(true).length > 0) {
                        return;
                    }
                    holder.registerProblem(nameIdentifier, SASSBundle.message("inspections.unresolved.placeholder.selector", selector.getName()), new LocalQuickFix[0]);
                }
            }
        };
        if (sASSSCSSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssUnresolvedPlaceholderSelectorInspection", "buildVisitor"));
        }
        return sASSSCSSElementVisitor;
    }
}

