/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.inspections.suppress;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressAllForAtRuleCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressAllForMixinCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressAllForRulesetCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForAtRuleCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForFunctionCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForMixinCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForRulesetCommentFix;
import org.jetbrains.plugins.scss.inspections.suppress.SassScssSuppressForStatementCommentFix;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssParameter;
import org.jetbrains.plugins.scss.psi.SassScssRuleset;
import org.jetbrains.plugins.scss.psi.SassScssStatement;

public class SassScssSuppressionUtil {
    public static boolean isSuppressedFor(final @Nullable PsiElement element, final @NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "isSuppressedFor"));
        }
        if (element == null) {
            return true;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (SassScssSuppressionUtil.getSuppressedInCssStatement(element, toolId) != null) {
                    return true;
                }
                if (SassScssSuppressionUtil.getSuppressedInSassStatement(element, toolId) != null) {
                    return true;
                }
                if (SassScssSuppressionUtil.getSuppressedInCssRuleset(element, toolId) != null) {
                    return true;
                }
                if (SassScssSuppressionUtil.getSuppressedInSassRuleset(element, toolId) != null) {
                    return true;
                }
                if (SassScssSuppressionUtil.getSuppressedInBlockAtRule(element, toolId) != null) {
                    return true;
                }
                return false;
            }
        });
    }

    @Nullable
    public static PsiElement getSuppressibleStatement(@Nullable PsiElement context) {
        PsiElement statement = PsiTreeUtil.getTopmostParentOfType((PsiElement)context, CssOneLineStatement.class);
        if (statement != null && statement.getParent() instanceof SassScssParameter) {
            return null;
        }
        return statement;
    }

    @Nullable
    public static PsiElement getSuppressibleCssRuleset(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssRuleset.class});
    }

    @Nullable
    public static PsiElement getSuppressibleMixin(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{SassScssMixinDeclaration.class});
    }

    @Nullable
    public static PsiElement getSuppressibleFunction(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{SassScssFunctionDeclaration.class});
    }

    @Nullable
    public static PsiElement getSuppressibleAtRule(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
    }

    @Nullable
    private static PsiElement getSuppressedInSassStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInSassStatement"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInSassStatement"));
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, SassScssStatement.class);
    }

    @Nullable
    private static PsiElement getSuppressedInCssStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInCssStatement"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInCssStatement"));
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssOneLineStatement.class);
    }

    @Nullable
    private static PsiElement getSuppressedInSassRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInSassRuleset"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInSassRuleset"));
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, SassScssRuleset.class);
    }

    @Nullable
    private static PsiElement getSuppressedInCssRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInCssRuleset"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInCssRuleset"));
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssRuleset.class);
    }

    @Nullable
    private static PsiElement getSuppressedInBlockAtRule(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInBlockAtRule"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressedInBlockAtRule"));
        }
        return SassScssSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssAtRule.class);
    }

    @Nullable
    private static PsiElement getStatementToolSuppressedIn(@NotNull PsiElement element, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getStatementToolSuppressedIn"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getStatementToolSuppressedIn"));
        }
        if (statementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementClass", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getStatementToolSuppressedIn"));
        }
        PsiElement current = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{statementClass});
        while (current != null) {
            PsiElement result = SuppressionUtil.getStatementToolSuppressedIn((PsiElement)current, (String)toolId, statementClass);
            if (result != null) {
                return result;
            }
            current = PsiTreeUtil.getParentOfType((PsiElement)current, statementClass, (boolean)true);
        }
        return null;
    }

    @NotNull
    public static SuppressQuickFix[] getSuppressActions(@NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressActions"));
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SassScssSuppressForStatementCommentFix(toolId), new SassScssSuppressForFunctionCommentFix(toolId), new SassScssSuppressForMixinCommentFix(toolId), new SassScssSuppressAllForMixinCommentFix(), new SassScssSuppressForRulesetCommentFix(toolId), new SassScssSuppressAllForRulesetCommentFix(), new SassScssSuppressForAtRuleCommentFix(toolId), new SassScssSuppressAllForAtRuleCommentFix()};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/suppress/SassScssSuppressionUtil", "getSuppressActions"));
        }
        return suppressQuickFixArray;
    }
}

