/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalSettingsPanel;

public class TerminalOptionsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
Disposable {
    public static final String TERMINAL_SETTINGS_HELP_REFERENCE = "reference.settings.terminal";
    private TerminalSettingsPanel myPanel;
    private final TerminalOptionsProvider myOptionsProvider;
    private final TerminalProjectOptionsProvider myProjectOptionsProvider;

    public TerminalOptionsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/terminal/TerminalOptionsConfigurable", "<init>"));
        }
        this.myOptionsProvider = TerminalOptionsProvider.Companion.getInstance();
        this.myProjectOptionsProvider = TerminalProjectOptionsProvider.Companion.getInstance(project);
    }

    @NotNull
    public String getId() {
        if ("terminal" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/TerminalOptionsConfigurable", "getId"));
        }
        return "terminal";
    }

    @Nls
    public String getDisplayName() {
        return "Terminal";
    }

    public String getHelpTopic() {
        return TERMINAL_SETTINGS_HELP_REFERENCE;
    }

    public JComponent createComponent() {
        this.myPanel = new TerminalSettingsPanel();
        return this.myPanel.createPanel(this.myOptionsProvider, this.myProjectOptionsProvider);
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        this.myPanel = null;
    }
}

