/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.JBTabbedTerminalWidget;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalProcess;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalRunner;

public class TerminalHandlerImpl
extends TerminalHandlerBase {
    private final JBTabbedTerminalWidget myTerminalWidget;

    public TerminalHandlerImpl(@NotNull String presentableName, @NotNull Project project, @NotNull InputStream terminalOutput, @NotNull OutputStream terminalInput) {
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "org/jetbrains/plugins/terminal/cloud/TerminalHandlerImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/terminal/cloud/TerminalHandlerImpl", "<init>"));
        }
        if (terminalOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalOutput", "org/jetbrains/plugins/terminal/cloud/TerminalHandlerImpl", "<init>"));
        }
        if (terminalInput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalInput", "org/jetbrains/plugins/terminal/cloud/TerminalHandlerImpl", "<init>"));
        }
        super(presentableName);
        CloudTerminalProcess process = new CloudTerminalProcess(terminalInput, terminalOutput);
        CloudTerminalRunner terminalRunner = new CloudTerminalRunner(project, presentableName, process);
        this.myTerminalWidget = terminalRunner.createTerminalWidget((Disposable)project);
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }
}

