/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.asp;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.jetbrains.asp.AspBundle;
import com.jetbrains.asp.AspFileSyntaxHighlighter;
import com.jetbrains.asp.AspLanguage;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AspFileType
extends LanguageFileType
implements TemplateLanguageFileType {
    public static final AspFileType INSTANCE = new AspFileType();
    @NonNls
    private static final String ASP_EXTENSION = "asp";

    private AspFileType() {
        super((Language)AspLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/asp/AspFileType$1", "getEditorHighlighter"));
                }
                if (colors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/jetbrains/asp/AspFileType$1", "getEditorHighlighter"));
                }
                return new AspFileSyntaxHighlighter(project, virtualFile, colors);
            }
        });
    }

    @NotNull
    public String getName() {
        if ("ASP" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/asp/AspFileType", "getName"));
        }
        return "ASP";
    }

    @NotNull
    public String getDescription() {
        String string = AspBundle.message("asp.core.file.type.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/asp/AspFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if (ASP_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/asp/AspFileType", "getDefaultExtension"));
        }
        return ASP_EXTENSION;
    }

    public Icon getIcon() {
        return PlatformIcons.CUSTOM_FILE_ICON;
    }

    @NotNull
    public static String getExtensions() {
        if ("asp;aspx;ascx" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/asp/AspFileType", "getExtensions"));
        }
        return "asp;aspx;ascx";
    }
}

