/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections.htmlAddLabelToForm;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.htmlInspections.HtmlFormInputWithoutLabelInspection;
import com.intellij.codeInspection.htmlInspections.htmlAddLabelToForm.CreateNewLabelAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class CreateLabelFromTextAction
implements LocalQuickFix,
HighPriorityAction {
    private final String myBundleKey;
    private final boolean myTextBeforeTag;
    private final String myName;

    public CreateLabelFromTextAction(@NonNls @PropertyKey(resourceBundle="messages.XmlBundle") String bundleKey, boolean textBeforeTag, String name) {
        this.myBundleKey = bundleKey;
        this.myTextBeforeTag = textBeforeTag;
        this.myName = name;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)this.myBundleKey, (Object[])new Object[]{this.myName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmlAddLabelToForm/CreateLabelFromTextAction", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        Pair<PsiElement, PsiElement> pair;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmlAddLabelToForm/CreateLabelFromTextAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/htmlAddLabelToForm/CreateLabelFromTextAction", "applyFix"));
        }
        PsiElement e = descriptor.getPsiElement();
        if (e == null) {
            return;
        }
        XmlTag myTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class);
        if (myTag == null) {
            return;
        }
        Pair<PsiElement, PsiElement> pair2 = pair = this.myTextBeforeTag ? HtmlFormInputWithoutLabelInspection.getNearestText((PsiElement)myTag, new HtmlFormInputWithoutLabelInspection.BackwardIterator()) : HtmlFormInputWithoutLabelInspection.getNearestText((PsiElement)myTag, new HtmlFormInputWithoutLabelInspection.ForwardIterator());
        if (pair == null) {
            return;
        }
        PsiElement myLeft = (PsiElement)pair.first;
        PsiElement myRight = (PsiElement)pair.second;
        StringBuilder sb = new StringBuilder("<a>");
        if (this.myTextBeforeTag) {
            for (element = myLeft.getParent().getFirstChild(); element != null && element != myLeft; element = element.getNextSibling()) {
                sb.append(element.getText());
            }
        } else {
            for (element = myRight.getNextSibling(); element != null; element = element.getNextSibling()) {
                sb.append(element.getText());
                if (element != element.getParent().getLastChild()) {
                    continue;
                }
                break;
            }
        }
        XmlTag tmpTag = CreateNewLabelAction.createElementFromText(project, myTag, sb.toString());
        for (PsiElement element2 : tmpTag.getChildren()) {
            if (element2 instanceof XmlText || element2 instanceof PsiComment) continue;
            element2.delete();
        }
        myLeft.getParent().replace((PsiElement)tmpTag);
        String id = CreateNewLabelAction.getId(myTag);
        if (id != null) {
            StringBuilder builder = new StringBuilder("\n<label for=\"").append(id).append("\">");
            for (PsiElement element3 = myLeft; element3 != null; element3 = element3.getNextSibling()) {
                builder.append(element3.getText());
                if (element3 == myRight) break;
            }
            builder.append("</label>");
            XmlTag labelTag = CreateNewLabelAction.createElementFromText(project, myTag, builder.toString());
            if (this.myTextBeforeTag) {
                myTag.getParent().addBefore((PsiElement)labelTag, (PsiElement)myTag);
            } else {
                myTag.getParent().addAfter((PsiElement)labelTag, (PsiElement)myTag);
            }
        } else {
            StringBuilder builder = new StringBuilder("\n<label>\n");
            if (!this.myTextBeforeTag) {
                builder.append(myTag.getText());
                builder.append("\n");
            }
            for (PsiElement element4 = myLeft; element4 != null; element4 = element4.getNextSibling()) {
                builder.append(element4.getText());
                if (element4 == myRight) break;
            }
            if (this.myTextBeforeTag) {
                builder.append("\n");
                builder.append(myTag.getText());
            }
            builder.append("\n</label>");
            XmlTag tag = CreateNewLabelAction.createElementFromText(project, myTag, builder.toString());
            myTag.replace((PsiElement)tag);
        }
    }
}

