/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections.htmltagreplace;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.HtmlTagReplaceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.XmlBundle;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceFontTagAction
implements LocalQuickFix {
    @NonNls
    private static final Map<String, String> ourSizesMap = new HashMap();

    @NotNull
    public String getName() {
        String string = XmlBundle.message((String)"html.replace.tag.with.css.quickfix.text", (Object[])new Object[]{"font"});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceFontTagAction", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        if ("ReplaceDepracatedTag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceFontTagAction", "getFamilyName"));
        }
        return "ReplaceDepracatedTag";
    }

    private static PsiElement[] generateContainingElements(@NotNull Project project, String tagName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceFontTagAction", "generateContainingElements"));
        }
        XmlFile xmlFile = HtmlTagReplaceUtil.genereateXmlFileWithSingleTag(project, "span");
        return HtmlTagReplaceUtil.getXmlNamesFromSingleTagFile(xmlFile);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceFontTagAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceFontTagAction", "applyFix"));
        }
        for (parent = descriptor.getPsiElement(); !(parent == null || parent instanceof XmlTag && "font".equals(((XmlTag)parent).getLocalName().toLowerCase())); parent = parent.getParent()) {
        }
        if (parent == null) {
            return;
        }
        String name = ((XmlTag)parent).getLocalName().toLowerCase();
        XmlTag tag = (XmlTag)parent;
        PsiElement[] replacePsiElements = ReplaceFontTagAction.generateContainingElements(project, name);
        int cnt = 0;
        for (PsiElement element : tag.getChildren()) {
            XmlToken token;
            IElementType type;
            if (!(element instanceof XmlToken) || (type = (token = (XmlToken)element).getTokenType()) != XmlTokenType.XML_NAME) continue;
            token.replace(replacePsiElements[cnt++]);
        }
        StringBuilder style = new StringBuilder();
        for (XmlAttribute attribute : tag.getAttributes()) {
            String value;
            if ("face".equals(attribute.getName())) {
                value = attribute.getValue();
                attribute.delete();
                style.append("font-family: ");
                style.append(value);
                style.append("; ");
                continue;
            }
            if ("color".equals(attribute.getName())) {
                value = attribute.getValue();
                attribute.delete();
                style.append("color: ");
                style.append(value);
                style.append("; ");
                continue;
            }
            if (!"size".equals(attribute.getName())) continue;
            value = attribute.getValue();
            attribute.delete();
            if (!ourSizesMap.containsKey(value)) continue;
            style.append("font-size: ");
            style.append(ourSizesMap.get(value));
            style.append("; ");
        }
        if (style.length() != 0) {
            boolean found = false;
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!"style".equals(attribute.getName())) continue;
                found = true;
                attribute.setValue(attribute.getValue() + " " + style.toString());
                break;
            }
            if (!found) {
                tag.setAttribute("style", style.toString());
            }
        }
    }

    static {
        ourSizesMap.put("-3", "59%");
        ourSizesMap.put("-2", "70%");
        ourSizesMap.put("-1", "smaller");
        ourSizesMap.put("+1", "larger");
        ourSizesMap.put("+2", "144%");
        ourSizesMap.put("+3", "172%");
        ourSizesMap.put("1", "xx-small");
        ourSizesMap.put("2", "x-small");
        ourSizesMap.put("3", "small");
        ourSizesMap.put("4", "medium");
        ourSizesMap.put("5", "large");
        ourSizesMap.put("6", "x-large");
        ourSizesMap.put("7", "xx-large");
    }
}

