/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.actions;

import com.intellij.html.actions.TableUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TableCellNavigator {
    public static boolean isActionAvailable(Editor editor, PsiFile file) {
        return TableUtil.isInsideTag(editor, file, new String[]{"td", "th"});
    }

    private static boolean isInsideTable(List<TableUtil.TableRow> table, int row, int column) {
        return row >= 0 && row < table.size() && column >= 0 && column < table.get(row).size();
    }

    public static void moveCaret(@NotNull Project project, @NotNull Editor editor, PsiFile file, int[] direction) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/html/actions/TableCellNavigator", "moveCaret"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/html/actions/TableCellNavigator", "moveCaret"));
        }
        PsiElement element = TableUtil.getCurrentPsiElement(editor, file);
        element = TableUtil.getParentWithName(element, new String[]{"td", "th"});
        assert (element != null);
        PsiElement root = TableUtil.getTablePsiElement(element);
        if (root != null) {
            Pair<List<TableUtil.TableRow>, TableUtil.TableCell> pair = TableUtil.getTableAndPosition(root, element);
            List table = (List)pair.first;
            TableUtil.TableCell cell = (TableUtil.TableCell)pair.second;
            int x = cell.startColumn;
            int y = cell.startRow;
            int newX = x;
            int newY = y;
            do {
                x = newX;
                y = newY;
            } while (((TableUtil.TableRow)table.get((int)newY)).get((int)newX).tag == cell.tag && TableCellNavigator.isInsideTable(table, newY += direction[0], newX += direction[1]));
            TableUtil.TableCell newCell = ((TableUtil.TableRow)table.get(y)).get(x);
            XmlTag tag = newCell.tag;
            TableUtil.moveCaretTo(editor, TableUtil.findClosingToken(tag));
        }
    }

    public static class Directions {
        public static int[] RIGHT = new int[]{0, 1};
        public static int[] LEFT = new int[]{0, -1};
        public static int[] UP = new int[]{-1, 0};
        public static int[] DOWN = new int[]{1, 0};
    }
}

