/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.actions;

import com.intellij.html.actions.TableUtil;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TableColumnAdder {
    public static boolean isActionAvailable(Editor editor, PsiFile file) {
        return TableUtil.isInsideTag(editor, file, new String[]{"td", "th"});
    }

    private static void addCellToTag(@NonNls Project project, TableUtil.TableCell cell, boolean toPlaceBefore, boolean insideHeader) throws IncorrectOperationException {
        if (toPlaceBefore) {
            XmlTag newCell = TableColumnAdder.createTableCellXmlTag(project, insideHeader);
            cell.tag.getParent().addBefore((PsiElement)newCell, (PsiElement)cell.tag);
        } else {
            XmlTag newCell = TableColumnAdder.createTableCellXmlTag(project, insideHeader);
            cell.tag.getParent().addAfter((PsiElement)newCell, (PsiElement)cell.tag);
        }
    }

    private static void addColumnToTable(@NotNull Project project, List<TableUtil.TableRow> table, int columnNumber) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/html/actions/TableColumnAdder", "addColumnToTable"));
        }
        block2: for (int i = 0; i < table.size(); ++i) {
            TableUtil.TableRow row = table.get(i);
            if (row.isEmpty()) {
                XmlTag element = TableColumnAdder.createTableCellXmlTag(project, row.insideHeader);
                row.rowTag.add((PsiElement)element);
                continue;
            }
            if (columnNumber < 0) {
                TableUtil.TableCell cell = null;
                for (int j = 0; j < row.size(); ++j) {
                    TableUtil.TableCell currentCell = row.get(j);
                    if (currentCell.startRow != i) continue;
                    cell = currentCell;
                    break;
                }
                if (cell == null) continue;
                TableColumnAdder.addCellToTag(project, cell, true, row.insideHeader);
                continue;
            }
            for (int j = Math.min(columnNumber, row.size() - 1); j >= 0; --j) {
                TableUtil.TableCell cell = row.get(j);
                for (XmlAttribute attribute : cell.tag.getAttributes()) {
                    if (!"colspan".equals(attribute.getLocalName().toLowerCase())) continue;
                    if (cell.startRow != i) continue block2;
                    try {
                        cell.tag.setAttribute("colspan", String.valueOf(Integer.parseInt(cell.tag.getAttributeValue("colspan")) + 1));
                        continue block2;
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
                if (cell.startRow != i) continue;
                TableColumnAdder.addCellToTag(project, cell, false, row.insideHeader);
                continue block2;
            }
        }
    }

    private static XmlTag createTableCellXmlTag(@NotNull Project project, boolean inHeader) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/html/actions/TableColumnAdder", "createTableCellXmlTag"));
        }
        String filetext = "<root>" + (inHeader ? "<th></th>" : "<td></td>") + "</root";
        XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xml", (Language)XMLLanguage.INSTANCE, (CharSequence)filetext);
        XmlTag tag = xmlFile.getDocument().getRootTag();
        for (PsiElement element : tag.getChildren()) {
            if (!(element instanceof XmlTag)) continue;
            tag = (XmlTag)element;
        }
        return tag;
    }

    private static boolean moveCaretToFirstEmptyCell(@NotNull Editor editor, PsiElement element) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/html/actions/TableColumnAdder", "moveCaretToFirstEmptyCell"));
        }
        if (element instanceof XmlTag && ("td".equals(((XmlTag)element).getName().toLowerCase()) || "th".equals(((XmlTag)element).getName().toLowerCase())) && ("<td></td>".equals(element.getText()) || "<th></th>".equals(element.getText()))) {
            PsiElement closingToken = element.getChildren()[3];
            TableUtil.moveCaretTo(editor, closingToken);
            return true;
        }
        for (PsiElement child : element.getChildren()) {
            if (!TableColumnAdder.moveCaretToFirstEmptyCell(editor, child)) continue;
            return true;
        }
        return false;
    }

    public static void addColumn(@NotNull Project project, Editor editor, PsiFile file, boolean toInsertBefore) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/html/actions/TableColumnAdder", "addColumn"));
        }
        PsiElement element = TableUtil.getCurrentPsiElement(editor, file);
        element = TableUtil.getParentWithName(element, new String[]{"td", "th"});
        assert (element != null);
        PsiElement root = TableUtil.getTablePsiElement(element);
        Pair<List<TableUtil.TableRow>, TableUtil.TableCell> pair = TableUtil.getTableAndPosition(root, element);
        List table = (List)pair.first;
        int columnNumber = ((TableUtil.TableCell)pair.second).startColumn;
        if (!toInsertBefore) {
            columnNumber += TableUtil.getColumnsNumber((XmlTag)element);
        }
        TableColumnAdder.addColumnToTable(project, table, columnNumber - 1);
        TableColumnAdder.moveCaretToFirstEmptyCell(editor, root);
    }
}

